<?php 
/***********************
 Sphider configuration file
***********************/
include_once("modules/search/configs/config.inc.php");
global $searchConf;

/*********************** 
General settings 
***********************/

// Sphider version 
$GLOBALS['version_nr']	= '1.3.3';

//Language of the search page 
#$GLOBALS['language']	= 'en';

// Template name/directory in templates dir
$GLOBALS['template']	= 'standard';

//Administrators email address (logs can be sent there)	
$GLOBALS['admin_email']	= 'admin@localhost';

// Print spidering results to standard out
$GLOBALS['print_results']	= 1;

// Temporary directory, this should be readable and writable
$GLOBALS['tmp_dir']	= $searchConf['tmp_dir'];


/*********************** 
Logging settings 
***********************/

// Should log files be kept
$GLOBALS['keep_log']	= 0;

//Log directory, this should be readable and writable
$GLOBALS['log_dir']	= 'log';

// Log format
$GLOBALS['log_format']	= 'html';

//  Send log file to email 
$GLOBALS['email_log']	= 0;


/*********************** 
Spider settings 
***********************/

// Min words per page required for indexing 
$GLOBALS['min_words_per_page']	= 10;

// Words shorter than this will not be indexed
$GLOBALS['min_word_length']	= 3;

// Keyword weight depending on the number of times it appears in a page is capped at this value
$GLOBALS['word_upper_bound']	= 100;

// Index numbers as well
$GLOBALS['index_numbers']	= 1;

// if this value is set to 1, word in domain name and url path are also indexed,// so that for example the index of www.php.net returns a positive answer to query 'php' even 	// if the word is not included in the page itself.
$GLOBALS['index_host']	= 0;


// Wether to index keywords in a meta tag 
$GLOBALS['index_meta_keywords']	= 1;

// Index pdf files
$GLOBALS['index_pdf']	= 0;

// Index doc files
$GLOBALS['index_doc']	= 0;

// Index xls files
$GLOBALS['index_xls']	= 0;

// Index ppt files
$GLOBALS['index_ppt']	= 0;

//executable path to pdf converter
$GLOBALS['pdftotext_path']	= 'c:\temp\pdftotext.exe';

//executable path to doc converter
$GLOBALS['catdoc_path']	= 'c:\temp\catdoc.exe';

//executable path to xls converter
$GLOBALS['xls2csv_path']	= 'c:\temp\xls2csv';

//executable path to ppt converter
$GLOBALS['catppt_path']	= 'c:\temp\catppt';

// User agent string 
$GLOBALS['user_agent']	= 'Sphider';

// Minimal delay between page downloads 
$GLOBALS['min_delay']	= 0;

// Use word stemming (e.g. find sites containing runs and running when searching for run) 
$GLOBALS['stem_words']	= 0;

// Strip session ids (PHPSESSID, JSESSIONID, ASPSESSIONID, sid) 
$GLOBALS['strip_sessids']	= 1;


/*********************** 
Search settings 
***********************/

// default for number of results per page
$GLOBALS['results_per_page']	= $searchConf['results_per_page'];

// Number of columns for categories. If you increase this, you might also want to increase the category table with in the css file
$GLOBALS['cat_columns']	= 2;

// Can speed up searches on large database (should be 0)
$GLOBALS['bound_search_result']	= 0;

// The length of the description string queried when displaying search results. // If set to 0 (default), makes a query for the whole page text, // otherwise queries this many bytes. Can significantly speed up searching on very slow machines 
$GLOBALS['length_of_link_desc']	= 0;

// Number of links shown to next pages
$GLOBALS['links_to_next']	= 9;

// Show meta description in results page if it exists, otherwise show an extract from the page text.
$GLOBALS['show_meta_description']	= 1;

// Advanced query form, shows and/or buttons
$GLOBALS['advanced_search']	= 0;

// Query scores are not shown if set to 0
$GLOBALS['show_query_scores']	= 1;	



 // Display category list
$GLOBALS['show_categories']	= 1;

// Length of page description given in results page
$GLOBALS['desc_length']	= $searchConf['desc_length'];

// Show only the 2 most relevant links from each site (a la google)
$GLOBALS['merge_site_results']	= 0;

// Enable spelling suggestions (Did you mean...)
$GLOBALS['did_you_mean_enabled']	= 1;

// Enable Sphider Suggest 
$GLOBALS['suggest_enabled']	= 0;

// Search for suggestions in query log 
$GLOBALS['suggest_history']	= 1;

// Search for suggestions in keywords 
$GLOBALS['suggest_keywords']	= 0;

// Search for suggestions in phrases 
$GLOBALS['suggest_phrases']	= 0;

// Limit number of suggestions 
$GLOBALS['suggest_rows']	= 10;


/*********************** 
Weights
***********************/

// Relative weight of a word in the title of a webpage
$GLOBALS['title_weight']	= 20;

// Relative weight of a word in the domain name
$GLOBALS['domain_weight']	= 60;

// Relative weight of a word in the path name
$GLOBALS['path_weight']	= 10;

// Relative weight of a word in meta_keywords
$GLOBALS['meta_weight']	= 5;

?>
