<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 26-06-08
 * date modified		: $Id$
 */

class NewsController extends AbstractController {
	private $path;
	private $contentConf;

	public function __construct($mod, $text=array()) {
		parent:: __construct($mod, $text);

		$this->mainPath = BASEMODULESPATH ."modules/content/configs/config.inc.php";
		if(!is_file(BASEPATH ."modules/content/configs/nieuws2.inc.php")){
			$this->path = BASEMODULESPATH ."modules/content/configs/nieuws2.inc.php";
		} else {
			$this->path = BASEPATH ."modules/content/configs/nieuws2.inc.php";
		}
		
		include($this->mainPath);	
		include($this->path);	
		$this->contentConf = $contentConf;

		$action = new Action("addNews", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("archive", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("moveNews", false, false, array(), true, true);
		$this->addAction($action);

		$action = new Action("hide", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("edit", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("delete", false, false, array(), true, true);
		$this->addAction($action);

		$action = new Action("deleteFile", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("add", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("show");
		$this->setDefaultAction($action);
	}

	public function show() {
		$contentManager = new ContentManager(getSelectedCat(), false,$this->contentConf);
		$items = $contentManager->getContentItems();
		$list = new Listing();
		$list->setNoSorting();

		foreach($items as $item) {
			$list->addRecord($item->getTemplateData());
		}
		
		$this->mod->assign("NEWSITEMS",domodule('lister', '', 'news', array('list' => $list)));
	}

	public function addNews() {
		$this->showForm();
	}

	public function edit() {
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}

		$this->showForm($content);
	}

	public function add() {
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}

		$content->setCategoryId(getSelectedCat());
		
		if($content->readFromForm()){
			$content->save();
			$this->show();
		} else {
			$this->showForm($content);
		}
	}

	public function moveNews(){
		$contentManager = new ContentManager(getSelectedCat(), false,$this->contentConf);
		$moveid = $this->currentAction->getArgumentValue('itemId');
		$direction = $this->currentAction->getArgumentValue('direction');
		$contentManager->moveContentItemPosition($moveid, $direction);
	}

	public function delete() {
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
			$content->delete();
		}
	}	
		
	public function showForm($content = false) {
		if(!$content){
			$content = new Content(false, false,$this->contentConf);
		}

		foreach($GLOBALS['available_languages'] as $language => $langName) {
			$this->mod->assign('THISLANGUAGE', $langName);
			$this->mod->assign('THISLANG', $language);
			if($content){
				$this->mod->assign('ITEM', $content->getTemplateData($language));
			}
			$this->mod->parse('module.itemfields.language_dependant');
		}
		$this->mod->parse('module.itemfields');
		$this->showFileForm($content);
		$this->mod->parse('module.formparts');
	}

	public function showFileForm($content = false) {
		if($this->contentConf['number_of_files']) {
			parsefiles($content->getFiles(), &$this->mod, $this->contentConf['number_of_files']);
		}
	}

	public function hide() {
		$id = $this->currentAction->getArgumentValue("id");
	
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}

		$content->toggleHide();
		$content->save();
		$this->show();
	}

	public function archive() {
		$id = $this->currentAction->getArgumentValue("id");
	
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}
		if($content->getValue("archive") == "1"){
			$content->setFieldValue("archive", "0");
		} else {
			$content->setFieldValue("archive", "1");
		}
		$content->save();
		$this->show();
	}

	public function deleteFile() {
		$file = $this->currentAction->getArgumentValue("file");
		$id = $this->currentAction->getArgumentValue("id");
	
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}

		$content->deleteFile($file);
		$content->readFromForm();
		$this->showForm($content);
	}
}
?>
