<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 26-06-08
 * date modified		: $Id$
 */

class LoginController extends AbstractController {
	private $userManager;
	public function __construct($mod, $text=array()) {
		parent:: __construct($mod, $text);
		$this->userManager = new UserManager();

		$action = new Action("login", false, false, array(), true, true);
		$action->addArgument("username", ALL);
		$action->addArgument("password", ALL);
		$action->setLogging(true);
		$this->addAction($action);
		$action = new Action("logout", false, false, array(), true, true);
		$this->addAction($action);
		$action = new Action("show");
		$this->setDefaultAction($action);
	}

	public function login() {
		if($this->userManager->login($this->currentAction->getArgumentValue("username"), $this->currentAction->getArgumentValue("password"))){
			$this->message('welcome');
			$this->message($this->currentAction->getArgumentValue("username"), false, false, true);
			autojump();
		} else {
			$this->message('badLogin');
		}
	}

	public function logout() {
		$this->userManager->logOffUser();
		session_destroy();
		session_start();
		$this->message('loggedOut');
		autojump();
	}

	public function show() {
		if($this->userManager->isLoggedIn() && !$this->userManager->isDefaultUser()){
			$user = $this->userManager->getLoggedInUser();
			$this->mod->assign("USER", $user->getTemplateData());
			if($user->isSuperUser()){
				$this->mod->parse("module.userinfo.superuser");
			} else {
				$this->mod->parse("module.userinfo.nosuperuser");
			}
			$this->mod->parse("module.userinfo");
		} else {
			$this->mod->parse("module.login");
		}
	} 
}
?>
