<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 11-06-08
 * date modified		: $Id$
 */

class ContentListerController extends AbstractController {
	private $list;	
	private $settings;	
	private $selectedItem = false;
	private $searchFields = array();
	private $cacheName;
	private $var;

	public function __construct($mod, $text=array(), $list=False, $cacheName=False, $settings = array()) {
		parent:: __construct($mod, $text);

		$this->mod->assign('TEXT', $text);

		$this->list = $list;
		$this->settings = $settings;
		$this->cacheName = ($cacheName ? $cacheName : getSelectedCat());
		if(!$list){
			$_SESSION['messages'][] = "Error: No list defined";
			$this->list = new Listing();
		}

		$action = new Action("order", false, false, array(),true);
		$action->addArgument("order", ALL);
		$action->addArgument("direction", DIRECTION);
		$this->addAction($action);
		
		$action = new Action("createList", false, false, array(), false);
		$this->setDefaultAction($action);
		$this->settingOptions = array('enableHide', 'enableArchive', 'enableMove');
	}
	
	public function setVar($var) {
		$this->var = $var;
	}
	
	public function setSearchFields($searchFields) {
		$this->searchFields = $searchFields;
	}
	public function createList() {
		// variabelen die niet bij een lijst horen registreren
		$this->mod->assign('VAR', $this->list->getVar());

		foreach($this->settingOptions as $option) {
			if(isset($this->settings[$option]) and $this->settings[$option] ==  'True') {
				$this->mod->parse('module.'.$option);
			}
		}

		$filter = $this->currentAction->getArgumentValue("filter");
		$field = $this->currentAction->getArgumentValue("field");
		$_SESSION['listing'][$this->cacheName]['order'] = $this->currentAction->getArgumentValue('order');
		$_SESSION['listing'][$this->cacheName]['orderDirection'] = $this->currentAction->getArgumentValue('direction');
		$dontSort = False;
		if (($this->list->defaultOrder or $this->list->defaultOrderDirection) and $this->currentAction->getArgumentValue('order') == '') {
			$_SESSION['listing'][$this->cacheName]['order'] = $this->list->defaultOrder;
			$_SESSION['listing'][$this->cacheName]['orderDirection'] = $this->list->defaultOrderDirection;
			$dontSort = True;
		}

		if($filter <> "" && $field <> ""){
			$this->list->resetFilter();
			$this->list->addFilter($field, $filter);
		}
		
		###
		# Order the records	
		###
		$order = false;	
		$orderDirection = false;
		$nextDirection = "down";
		if(isset($_SESSION['listing'][$this->cacheName]['order'])){
			$order = $_SESSION['listing'][$this->cacheName]['order'];
		}
		if(isset($_SESSION['listing'][$this->cacheName]['orderDirection'])){
			$orderDirection = $_SESSION['listing'][$this->cacheName]['orderDirection'];
			if($orderDirection == "down"){
				$nextDirection = "up";
			}
		}
		$this->mod->assign('DIRECTION', $nextDirection);

		if(!$dontSort and $order != '' and $orderDirection != '') {
			$this->list->orderRecords($order, $orderDirection);
		}

		# get number of pages
		$noPages = $this->list->getNumberOfPages();


		###
		# Show the records	
		###
		$page = $this->currentAction->getArgumentValue("page");
		if(!$page) {
			if(isset($_SESSION['listing'][$this->cacheName]['page'])){
				$page = $_SESSION['listing'][$this->cacheName]['page'];
			} else {
				$page = 1;
			}
		}
		if($noPages < $page) {
			$page = 1;
		}

		$data['total'] = $this->list->count();
		$data['pagecountmin'] = $this->list->getPageSize() * ($page -1);
		$data['pagecountmax'] = $this->list->getPageSize() * $page;
		$this->mod->assign("DATA",$data);

		$_SESSION['listing'][$this->cacheName]['page'] = $page;

		foreach($this->list->getPagedRecords($page) as $itemCount => $record) {
			$this->mod->assign('itemCount', $itemCount+1+(($page-1)*$this->list->getPageSize()));
			if(isset($record['listtitle']) && $record['listtitle'] == '') {
				$record['listtitle'] = "-empty-";
			}
			$this->mod->assign('ITEM', $record);

			// Foto's weergeven
			if(isset($record['photos']) && is_array($record['photos'])) {
				foreach($record['photos'] as $photo){
					$this->mod->assign('PHOTOSMALL', $photo['small']);
					$this->mod->assign('PHOTOMEDIUM', $photo['medium']);
					$this->mod->assign('PHOTOLARGE', $photo['large']);
					$this->mod->parse('module.itemlist.item.photo');
				}
			}

			foreach($this->settingOptions as $option) {
				if(isset($this->settings[$option]) and $this->settings[$option] ==  'True') {
					$this->mod->parse('module.itemlist.item.'.$option);
				}
			}

			$this->mod->parse('module.itemlist.item');
		}

		foreach($this->list->getHeader() as $key) {
			$this->mod->assign('field', $key);
			if($key == $field) {
				$this->mod->assign('selected', "SELECTED");
			} else {
				$this->mod->assign('selected', "");
			}
			$this->mod->assign('FILTER', $filter);

			$this->mod->parse('module.filterItem');
		}


		###
		# Show the pages	
		###
		if($noPages > 1) {
			for($p = 1; $p <= $noPages; $p++){
				$this->mod->assign('PAGE', $p);
				if($p == $page) {
					$this->mod->assign('CURRENT', "current");
				} else {
					$this->mod->assign('CURRENT', "");
				}
				$this->mod->parse('module.itemlist.pages.page');
			}
			$this->mod->parse('module.itemlist.pages');
		}
		$this->mod->assign("SETTINGS",$this->settings);
		$this->mod->parse('module.itemlist');
	}

    public function addPhotos($item, $modPath) {
        // fotos eventueel resizen
        if(isset($item['photo']) && is_array($item['photo'])) {
            foreach($item['photo'] as $photo){
                $this->mod->assign('PHOTOSMALL', mypicture( $photo['myfile'], 'small'));
                $this->mod->assign('PHOTOMEDIUM', mypicture($photo['myfile'], 'medium'));
                $this->mod->assign('PHOTOLARGE', mypicture( $photo['myfile'], 'large'));
                $this->mod->parse($modPath);
            }
        }
    }

	
	public function order(){
		$_SESSION['listing'][$this->cacheName]['order'] = $this->currentAction->getArgumentValue('order');
		$_SESSION['listing'][$this->cacheName]['orderDirection'] = $this->currentAction->getArgumentValue('direction');
	}
}
?>
