<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 26-06-08
 * date modified		: $Id$
 */

class LfgController extends AbstractController {
	private $userManager;
	public function __construct($mod, $text=array()) {
		parent:: __construct($mod, $text);
		$this->userManager = new UserManager();

		$action = new Action("generate", false, false, array(), false, true);
		$action->addArgument("path", ALL);
		$action->addArgument("language", ALL);
		$this->addAction($action);

		$action = new Action("show");
		$this->setDefaultAction($action);
	}

	public function show() {
		$path = $this->currentAction->getArgumentValue("path");
		$language = $this->currentAction->getArgumentValue("language");
		if(trim($path)==""){
			$path = BASEPATH;
		}
		$this->mod->assign("path", $path);
	}

	public function generate(){
		$path = $this->currentAction->getArgumentValue("path");
		$language = $this->currentAction->getArgumentValue("language");
		$file['date'] = date("Y/m/d");
		$this->mod->assign("FILE", $file);
		$this->mod->assign("path", $path);
		$this->mod->assign("language", $language);
		$fileBrowser = new FileBrowser($path, false);
		$fileBrowser->setListFiles(true);
		$fileBrowser->addFilter('/.+(templates).+(\.html)/');

		$general = array();
		$generalfilename = BASEMODULESPATH . "general.$language.php";
		if(is_file($generalfilename)){
			include($generalfilename);
		}
		$generalfilename = $path . "general.$language.php";
		if(is_file($generalfilename)){
			include($generalfilename);
		}
		$alreadySet = array();

		foreach($fileBrowser->getFlattenFileList($fileBrowser->createFileBrowserWithoutTemplate()) as $filename){
			if(is_file($filename)){
				$file['filename'] = $filename;
				$this->mod->assign("FILE", $file);

				$handle = file_get_contents($filename, "r");
				$results = array();
				preg_match_all("/\{TEXT\.[a-zA-Z0-9]+\}/i", $handle, $results);
						
				if(isset($results['0']) and count($results['0']) > 0){
					$no = 0;
					foreach ($results['0'] as $key => $value) {
						$item = array();
						$item['key'] = substr($value, strpos($value, ".")+1 , strlen($value) - strpos($value, ".") - 2);
					
						if(isset($general[$item['key']])){
							$item['value'] = $general[$item['key']];
						}
						$this->mod->assign("ITEM", $item);
	
						if(!array_key_exists ($item['key'] ,$alreadySet)) {
							$alreadySet[$item['key']] = "";
							$this->mod->parse("module.file.items.item");
							$no++;
						} else {
							#$this->mod->parse("module.file.items.alreadyset");
						}
					}
					if($no > 0){
						$this->mod->parse("module.file.items");
					}
				}
			}
		}
		
		$this->mod->parse('module.file');
			
		$this->show();
	}
}
?>
