<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 11-06-08
 * date modified		: $Id$
 */

# LET OP DIT IS OUD ER IS NU EEN FILEBROWSER CLASS
# DIT IS PUUR ALS VOORBEELD MET NAME DE TEMPLATE

class FileBrowserController extends AbstractController {
	private $number = 0;
	private $cache = array();
	public function __construct($mod, $text=array(), $configPath = false) {
		parent:: __construct($mod, $text);
		if(isset($_SESSION["filebrowserCache"])){
			$this->cache = $_SESSION["filebrowserCache"];
		}

		$action = new Action("createFileBrowser");
		$this->setDefaultAction($action);
		$action = new Action("browse");
		$action->addArgument("parentId", ALL);
		$this->addAction($action);
	}

	public function browse() {
		if(count($this->cache)){
			$directory = new RecursiveDirectoryIterator($this->cache[$this->currentAction->getArgumentValue("parentId")]);
			$dirlisting = $this->dirlist($directory);
			echo $this->genList($dirlisting, false);
		}
		exit;
	}
	
	public function createFileBrowser(){
		$path = "/www/mysmt/";
		$directory = new RecursiveDirectoryIterator($path);
		$dirlisting = $this->dirlist($directory);
		echo $this->genList($dirlisting);
		exit;
	}

	public function genList ($dirlisting, $toplevel = true){
		$part = new TemplateProxy("modules/filebrowser/templates/template.inc.html");
		if($toplevel) {
			$part->parse("module.itemlist.toplevel");
		} else {
			$part->parse("module.itemlist.secondlevel");
		}
		foreach ($dirlisting as $dir => $size) {
			if(!is_array($size)) {
				$this->number ++;
				$part->assign("NUMBER", $this->number);
				$part->assign("ITEM", $dir);
				$part->parse("module.itemlist.item");
			} else {
				$this->number ++;
				$part->assign("NUMBER", $this->number);
				$part->assign("ITEMCONTAINER", $dir);
				$part->assign("SUBITEMS", $this->genList($size, false));
				$part->parse("module.itemlist.subitems");
			}
			$this->cache[$this->number] = $dir;
		}
		if($toplevel) {
			$part->parse("module.toplevelending");
		}

		$part->parse("module.itemlist");
		$_SESSION['filebrowserCache'] = $this->cache;
		return $part->parseModule();
	}

	function dirlist(RecursiveDirectoryIterator $it, $maxDepth = 2, $depth = 0)
    {	
		$parentPath = $it->getPath();
		$result = array();
        foreach ($it as $v) {
            if ($v->isDir() and $v->getFileName() != "." and $v->getFileName() != "..") {
				if($depth < $maxDepth) {
					$newPath = $v->getPathname();
#echo $v->getPathname()."<br>";
					try{
		                $result[$v->getFileName()] = $this->dirlist(new RecursiveDirectoryIterator($newPath), $maxDepth, $depth + 1);
					} catch (Exception $ex){
						continue;
					}
					
				} else {
	                $result[$v->getFileName()] = "dir";
				}
            } else if ($v->getFileName() != "."&& $v->getFileName() != ".."){
    //            $result[$v->getFileName()] = "file";
			}
        }
		return $result;
    } 

	public function dirlist2 ($dir, $maxLevel = 2, $currentLevel = 0) {
		$tree = array();
		$dirs = array(array($dir, &$tree));
		$stop = false;		

		for($i = 0; $i < count($dirs) && !$stop; ++$i)
		{
			$d =& $dirs[$i][0];
			$tier =& $dirs[$i][1];
			$currentLevel++;
		
			for($d->rewind(); $d->valid(); $d->next())
			{
				if ($d->isDir())
				{
					$tier[$d->getFilename()] = array();
					$dirs[] = array($d->getChildren(), &$tier[$d->getFilename()]);
				}
				else
				{
					$tier[$d->getFilename()] = $d->getSize();
				}
			}
			if($currentLevel > $maxLevel){
				$stop = true;
			}
		}
		
		return $tree;
	}
}
?>
