<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 12-01-08
 * date modified		: $Id$
 */

# laat alle macroModules zien 
# edit/delete deze of 
# maak een nieuwe

$catconf = $GLOBALS['catconf'];

$macroModuleObj = new MacroModule;

if(isset($_GET['macromodules'])) {
	$thisname = '';
	$thismodule = '';
	$thisadminmodule = '';
	$thistemplate = '';
	$macromoduleId = (int)$_GET['macromodules'];
	if($macromoduleId > 0) {
		$_SESSION['editmacro'] = $macromoduleId;
		$macroModule = $macroModuleObj->getMacroModuleFromId($macromoduleId);
		$thisname = $macroModule->name;
		$thismodule = $macroModule->module;
		$thisadminmodule = $macroModule->adminmodule;
		$thistemplate = $macroModule->template;
		$mod->assign('name', $macroModule->name);
		$mod->assign('description', $macroModule->description);
	} else {
		$_SESSION['editmacro'] = False;
	}

        $templatePath = 'module.selectedMacro.allow_module_choice';
        parseSelectOptions(&$mod, $catconf['modules'], $thismodule, $templatePath.'.option');
        $mod->parse($templatePath);
    
        $templatePath = 'module.selectedMacro.allow_adminmodule_choice';
        parseSelectOptions(&$mod, $catconf['adminmodules'], $thisadminmodule, $templatePath.'.option');
        $mod->parse($templatePath);

		$categoryManager = new CategoryManager($catconf);
        $thisTemplates = $categoryManager->getAvailableTemplates($thisadminmodule);
        $thisTemplates += $categoryManager->getAvailableTemplates($thismodule);
        if (count($thisTemplates) > 1) {
            $templatePath = 'module.selectedMacro.allow_template_choice';
            parseSelectOptions(&$mod, $thisTemplates, $thistemplate, $templatePath.'.option');
            $mod->parse($templatePath);
        } else {
            $mod->parse('module.selectedMacro.allow_template_notemplates');
        }
        $mod->parse('module.selectedMacro');

}

if(isset($_GET['deletemacro'])) {
	$macroModuleObj->deleteMacroModule($_GET['deletemacro']);
	$_SESSION['messages'][] = $text['deleted'];
}

if(isset($_POST['saveMacro'])) {
	if(trim($_POST['name']) == '') {
		$_SESSION['messages'][] = "Easymodule naam verplicht!";
	} else {
		if(isset($_SESSION['editmacro']) && $_SESSION['editmacro'] > 0) {
			$macroModuleObj->replaceMacroModule(
				$_SESSION['editmacro'],
				trim($_POST['name']),
				$_POST['module'],
				$_POST['adminmodule'],
				$_POST['template'],
				trim($_POST['description'])
				);
		} else {
			$macroModuleObj->addMacroModule(
				trim($_POST['name']),
				$_POST['module'],
				$_POST['adminmodule'],
				$_POST['template'],
				trim($_POST['description'])
				);
		}
		$_SESSION['messages'][] = $text['saved'];
	}
}

$MacroModules = $macroModuleObj->getAllMacroModules();
foreach($MacroModules as $name => $macromoduleId) {
	if($name == '-') {
		continue;
	}
	$macroModule = $macroModuleObj->getMacroModuleFromId($macromoduleId, True);
	$mod->assign('MACROMODULE', $macroModule);
	$mod->parse('module.macrolist');
}

?>
