<?php

/*
 * Author			: E J Jonkers	
 * company			: DataCT	
 * date created		: 05-10-11
 * date modified	: $Id: general.inc.php 180 2007-10-25 11:03:00Z erik $
 */

function getSelectedCat(){
	if(isset($_SESSION['selectedcat'])) {
		return $_SESSION['selectedcat'];
	} else {
		return 0;
	}
}
function getSelectedParent(){
	if(isset($_SESSION['selectedparent'])) {
		return $_SESSION['selectedparent'];
	} else {
		return 0;
	}
}
function getSelectedLanguage() {
	if(isset($_SESSION['language'])){
		return $_SESSION['language'];
	} else {
		return DEFAULT_LANGUAGE;
	}
}
function getModuleDefaultSettings($module, $adminmodule){
	static $cache = array();
	$moduleKey = $module."_".$adminmodule;
	if(isset($cache[$moduleKey])) {
		return $cache[$moduleKey];
	}
	$path = array();
	$path[BASEPATH."modules/".$module."/permissions.inc.php"] = false;
	$path[BASEMODULESPATH."modules/".$module."/permissions.inc.php"] =false;
	$path[BASEPATH."modules/".$adminmodule."/permissions.inc.php"] = true;
	$path[BASEMODULESPATH."modules/".$adminmodule."/permissions.inc.php"] = true;
	$thisSettings = array();
	foreach ($path as $pathkey => $pathvalue){
		$settings = array();
		if (file_exists($pathkey)) {
			include($pathkey);
			#echo $pathkey . "<BR>";
			if(isset($settings)){
				//$result = array_merge($settings, $thisSettings);
				foreach ($settings as $setting){
#					$factory = new SettingFactory();
#					$setting = $factory->getSetting($this->getCategoryId(), $setting);
#					$thisSettings[$setting->getIdentificationString()] = $setting;
					$thisSettings[] = $setting;
				}
			}
		}		
	}
	$cache[$moduleKey] = $thisSettings;
	return $thisSettings;
}

function getCatInformation($catIds){
	$result = array();
	foreach($catIds as $catId){
		$catInf = array();
		$category = new Category($catId);
		$catInf['title'] = $category->getName();
		$catInf['path'] = $category->getCategoryPath();
		$result[$catId] = $catInf;
	}
	return $result;	
}

function docategoryURLName($urlName, $config=False){
	$cm = new CategoryManager();
	$catIds = $cm->getCategoryIdFromURLname($urlName);
	$catId = array_shift($catIds);
	return docategory($catId, $config);
}
function docategory($catId, $config=False){
	$oldSelectedCat = getSelectedCat();
	$_SESSION['selectedcat'] = $catId;
	$category = new Category($catId);
	if(!$config) {
		$config = $category->getTemplate();
	}
	$returnValue = domodule($category->getModule(), "", $config);
	$_SESSION['selectedcat'] = $oldSelectedCat;
	return $returnValue;
}

function domodule($module_name, $path='', $config='', $args = array()) {
	//Registering time etc.
	global $pagetrack;
	$starttime = explode(' ', microtime());
	$starttime = $starttime[1] + $starttime[0];

	$returnValue = null;
	global $mydb, $language;
	$debug = False;
	if(!$module_name) {
		if(isInAdmin()){
#			$_SESSION['messages'][] = "No administration module available for this menu item."; 
		}
		return null;
	}
	//$modulespath = $path.'modules/';
	$modulepath = $path.'modules/'.$module_name.'/';
	$mymodulepath = BASEPATH.$modulepath;
	$basemodulepath = BASEMODULESPATH.$modulepath;
	if($debug) {
		echo "<br><br>mymodulepath: $mymodulepath<br>";
		echo "basemodulepath: $basemodulepath<br>";
		echo "config: $config<br>";
	}


	if ($module_name != '' and (is_dir($mymodulepath) or is_dir($basemodulepath))) {
		if (file_exists($mymodulepath."templates/".$config.".inc.html")) {
			$mod = new TemplateProxy($mymodulepath."templates/".$config.".inc.html");
			$hasTemplate = True;
			$modulepath = $mymodulepath;
			if($debug) echo "1) included template: ".$mymodulepath."templates/".$config.".inc.html<br>";
		} else if (file_exists($basemodulepath."templates/".$config.".inc.html")) {
			$mod = new TemplateProxy($basemodulepath."templates/".$config.".inc.html");
			$hasTemplate = True;
			$modulepath = $basemodulepath;
			if($debug) echo "2) included template: ".$basemodulepath."templates/".$config.".inc.html<br>";
		} else if (file_exists($mymodulepath."templates/template.inc.html")) {
			$mod = new TemplateProxy($mymodulepath."templates/template.inc.html");
			$hasTemplate = True;
			$modulepath = $mymodulepath;
			if($debug) echo "3) included template: ".$mymodulepath."templates/template.inc.html<br>";
		} else if (file_exists($basemodulepath."templates/template.inc.html")) {
			$mod = new TemplateProxy($basemodulepath."templates/template.inc.html");
			$hasTemplate = True;
			$modulepath = $basemodulepath;
			if($debug) echo "4) included template: ".$basemodulepath."templates/template.inc.html<br>";
		} else {
			$hasTemplate = False;
			if($debug) echo "5) no template included for: $module_name <br> ";
		}
		if($hasTemplate) {
			$text = translate(&$mod);
			if(isset($_SESSION['selectedcat'])) {
				$mod->setCategoryId($_SESSION['selectedcat']);
			} else {
				$_SESSION['selectedcat'] = 0;
			}
		}

		$userManager = new UserManager();
		$user = $userManager->getLoggedInUser();
		if(!USERENVIROMENT and isset($_SESSION['selectedcat'])){
			$sel = $_SESSION['selectedcat'];
			if(is_object($user) && $user->hasPermissionOnCategory($_SESSION['selectedcat'])){
				#$_SESSION['messages'][] = "toegang op $sel <BR>"; 
			} else if(is_object($user)){
				$_SESSION['selectedcat'] = 0;
				$userManager->logOffUser();
				$_SESSION['messages'][] = "Please authenticate to access this module."; 
				autojump();
			}
		}

		global $general;

		if (file_exists($basemodulepath."configs/config.inc.php")) {
			include $basemodulepath."configs/config.inc.php";
		}
		if (file_exists($mymodulepath."configs/config.inc.php")) {
			include $mymodulepath."configs/config.inc.php";
		}
		if (file_exists($mymodulepath."configs/".$config.".inc.php")) {
			include $mymodulepath."configs/".$config.".inc.php";
		} else if (file_exists($basemodulepath."configs/".$config.".inc.php")) {
			include $basemodulepath."configs/".$config.".inc.php";
		}

		if (file_exists($mymodulepath."functions.inc.php")) {
			include_once $mymodulepath."functions.inc.php";
		} else if (file_exists($basemodulepath."functions.inc.php")) {
			include_once $basemodulepath."functions.inc.php";
		}
		
		if (file_exists($mymodulepath."handler.inc.php")) {
			include $mymodulepath."handler.inc.php";
		} else if (file_exists($basemodulepath."handler.inc.php")) {
			include $basemodulepath."handler.inc.php";
		}
		if($hasTemplate) {
			if(isset($modulePermission)){
				$returnValue = $mod->parseModule($modulePermission);
			} else {
				$returnValue = $mod->parseModule();
			}
		}
	} else {
		$_SESSION['messages'][] = "module \"$module_name\" doesn't exist! path: $basemodulepath";
	}
	//Registering time etc.
	$mtime = explode(' ', microtime());
	$totaltime = $mtime[0] + $mtime[1] - $starttime;
	isset($pagetrack['module_time']) ? $pagetrack['module_time'][] = round($totaltime,7) . " $module_name $config " : "";
	isset($pagetrack['sql_query_time']) ? $pagetrack['sql_query_time'][] = "End of module '$module_name' " : "";
	return $returnValue;
}


function translate($mymodule) {
	global $language, $modulepath;
	$debug = false;
	#$debug = true;
	$modulepath = str_replace("/templates", "", dirname($mymodule->filename));
	$modulepath = str_replace(BASEPATH, "", $modulepath);
	$modulepath = str_replace(BASEMODULESPATH, "", $modulepath);
	$pathpart = $modulepath."/language.";
	$general = array();
	
	$mymodulepath = BASEPATH;
	$basemodulepath = BASEMODULESPATH;
	$parentpath = ereg_replace('/modules/[a-z]{2,}$', '', $modulepath); # dit is eigenlijk de parent van de submodule
	$parentmodulepath = BASEPATH.$parentpath;
	$baseparentmodulepath = BASEMODULESPATH.$parentpath;

	global $general;

	if(file_exists($basemodulepath . 'general.'.$language.".php")) {
		include $basemodulepath .'general.'.$language.".php";
	}
	if(file_exists($mymodulepath . 'general.'.$language.".php")) {
		include $mymodulepath .'general.'.$language.".php";
	} 
	$text = array();
	if(file_exists($basemodulepath.$pathpart.$language.".php")) {
		include $basemodulepath.$pathpart.$language.".php";
		if($debug) echo "1) included language: ".$basemodulepath.$pathpart.$language.".php<br>";
	} elseif (file_exists($basemodulepath.$pathpart.DEFAULT_LANGUAGE.".php")) {
		include $basemodulepath.$pathpart.DEFAULT_LANGUAGE.".php";
		if($debug) echo "2) included language: ".$basemodulepath.$pathpart.DEFAULT_LANGUAGE.".php<br>";
	} else {
		if($debug) echo "3) not included language: ".$basemodulepath.$pathpart."*.php<br>";
	}
	if($parentmodulepath != BASEPATH.$modulepath) {
		#dit is een submodule dus include parent language file
		if(file_exists($parentmodulepath.'/language.'.$language.".php")) {
			include $parentmodulepath.'/language.'.$language.".php";
			if($debug) echo "4) included language: ".$parentmodulepath.'/language.'.$language.".php<br>";
		} elseif (file_exists($parentmodulepath.'/language.'.DEFAULT_LANGUAGE.".php")) {
			include $parentmodulepath.'/language.'.DEFAULT_LANGUAGE.".php";
			if($debug) echo "5) included language: ".$parentmodulepath.'/language.'.DEFAULT_LANGUAGE.".php<br>";
		} else {
			if($debug) echo "6) not included language: ".$parentmodulepath.'/language.'."*.php<br>";
		}
	}
	if($baseparentmodulepath != BASEMODULESPATH.$modulepath) {
		#dit is een submodule dus include parent language file
		if(file_exists($baseparentmodulepath.'/language.'.$language.".php")) {
			include $baseparentmodulepath.'/language.'.$language.".php";
			if($debug) echo "4-2) included language: ".$baseparentmodulepath.'/language.'.$language.".php<br>";
		} elseif (file_exists($baseparentmodulepath.'/language.'.DEFAULT_LANGUAGE.".php")) {
			include $baseparentmodulepath.'/language.'.DEFAULT_LANGUAGE.".php";
			if($debug) echo "5-2) included language: ".$baseparentmodulepath.'/language.'.DEFAULT_LANGUAGE.".php<br>";
		} else {
			if($debug) echo "6-2) not included language: ".$baseparentmodulepath.'/language.'."*.php<br>";
		}
	}
	if(file_exists($mymodulepath.$pathpart.$language.".php")) {
		include $mymodulepath.$pathpart.$language.".php";
		if($debug) echo "7) included language: ".$mymodulepath.$pathpart.$language.".php<br>";
	} elseif (file_exists($mymodulepath.$pathpart.DEFAULT_LANGUAGE.".php")) {
		include $mymodulepath.$pathpart.DEFAULT_LANGUAGE.".php";
		if($debug) echo "8) included language: ".$mymodulepath.$pathpart.DEFAULT_LANGUAGE.".php<br>";
	} else {
		if($debug) echo "9) not included language: ".$mymodulepath.$pathpart."*.php<br>";
	}

	$t = array_merge($general, $text);
	$mymodule->assign("TEXT", $t);
	return $t;
}

function reorderafter($records, $afterId, $rec_ID, $idfield) {
	$recs = array();
	foreach($records as $record) {
		if($record[$idfield] != $rec_ID) {
			$recs[] = $record;
		} else {
			$targetRecord = $record;
		}
		if($record[$idfield] == $afterId) {
			$recs[] = array(); # empty slot what we fill later
			$targetPrio = count($recs) -1;
		}
	}
	$recs[$targetPrio] = $targetRecord;
	return $recs;
}
function reorder($records, $move, $rec_ID, $idfield) {
	$tel = 1;
	$recs = array();
	while($rec = array_shift($records)) {
		if ($rec[$idfield] == $rec_ID) {
			$currentprio = $tel;
			if($move == 'up') {
				if(($tel - 1) == 0) {
					$recs[$tel] = $rec;
				} else {
					$prev = $recs[$tel-1];
					$recs[$tel-1] = $rec;
					$recs[$tel] = $prev;
				}
			} else { # if move == down
				$next = array_shift($records);
				if(!$next) {
					$recs[$tel] = $rec;
				} else {
					$recs[$tel] = $next;
					$recs[$tel+1] = $rec;
				}
				$tel++;
			}
		} else {
			$recs[$tel] = $rec;
		}
		$tel++;
	}
	return $recs;
}

function mypicture($pic, $sizetype='small', $thisWidth=Null, $thisHeight=Null, $thisSizeDir=Null) {
	$fileInfo = pathinfo($pic);
	$icon = geticon($fileInfo['extension']);
	if($icon != 'THUMB') {
		return showPicture(BASEPATH, ICONS, $icon);
	}
	if($sizetype == 'large') {
		$sizedir = LARGE_PICS;
		$width = $GLOBALS['LARGE_WIDTH'];
		$height = $GLOBALS['LARGE_HEIGHT'];
	} else if ($sizetype == 'medium') {
		$sizedir = MEDIUM_PICS;
		$width = $GLOBALS['MEDIUM_WIDTH'];
		$height = $GLOBALS['MEDIUM_HEIGHT'];
	} else {
		$sizedir = SMALL_PICS;
		$width = $GLOBALS['SMALL_WIDTH'];
		$height = $GLOBALS['SMALL_HEIGHT'];
	}
	if($thisWidth or $thisHeight) {
		$width = $thisWidth;
		$height = $thisHeight;
	}
	
	$srcpic = BASEPATH.UPLOADS_DIR.$pic;
	if($thisSizeDir) {
		$thisSizeDir = trim($thisSizeDir, '/');
		$thisSizeDir .= '/';
		$dstpic = BASEPATH.UPLOADS_DIR.$thisSizeDir.$pic;
		$sizedir = UPLOADS_DIR.$thisSizeDir;
	} else {
		$dstpic = BASEPATH.$sizedir.$pic;
	}
	//FIXME
	//Check if upscale..
	if(file_exists($srcpic) && !is_dir($srcpic)) {
	### keep small
		$orgpicsize = getimagesize($srcpic);
		if($orgpicsize[0] < $width or !$width){
			$width = $orgpicsize[0];
		}
		if($orgpicsize[1] < $height or !$height){
			$height = $orgpicsize[1];
		}
	} else {
		//$_SESSION['messages'][] = "Image ($srcpic) not found." ;
	}
	$doresize = false;
	if(file_exists($dstpic)) {
		# checksize
		$picsize = getimagesize($dstpic);
#       if(($picsize[0] > $width OR $picsize[1] > $height) or ($picsize[0] != $width AND $picsize[1] != $height)) {
#       if(($picsize[0] > $width OR $picsize[1] > $height)) {
        if(($picsize[0] > $width OR $picsize[1] > $height) or ($picsize[0] != $width AND $picsize[1] != $height)) {
        #echo "(($picsize[0] > $width OR $picsize[1] > $height) or ($picsize[0] != $width AND $picsize[1] != $height)) ";
			#resize
			$doresize = True;
		}
		if(filemtime($dstpic) < filemtime($srcpic)) {
			$doresize = True;
		}
	} else {
			$doresize = True;
	}
	if(!is_dir(BASEPATH.$sizedir)) {
	}
	if($doresize) {
		if(!is_dir(BASEPATH.$sizedir)) {
			if(!is_dir(BASEPATH.PICTURES)) {
				mkdir(rtrim(BASEPATH.PICTURES,'/'));
			}
			mkdir(rtrim(BASEPATH.$sizedir,'/'));
		}
		$mypic = new PICTURE($srcpic);
#$mypic->debug = True;
		if($mypic->error_is_set) {
			$_SESSION['messages'][] = $mypic->messages[0];
		} else {
			$mypic->setWidth($width);
			$mypic->setHeight($height);
			$mypic->save($dstpic);
		}
	}
	return showPicture(BASEPATH, $sizedir, $pic);
}

function showPicture($baseDir, $subDir, $picName) {
	$imgFile = $baseDir. $subDir. $picName;
	$p = '';
	if(file_exists($imgFile)) {
		$picsize = @getimagesize($imgFile);
		$p = array();
		$p['sizestring'] = $picsize[3];
		$p['picture'] = $subDir.$picName;
		$p['name'] = $picName;
	}
	return $p;
}

function parsefiles($thesefiles, $mod, $numberOfFiles) {
	global $contentConf;
	for($tel=1; $tel<=$numberOfFiles; $tel++) {
		if(isset($thesefiles[$tel])) {
			$thisfile = $thesefiles[$tel];
		} else {
			$thisfile = array();
		}
		if(isset($thisfile['myfile']) && !empty($thisfile['myfile'])) {
			$mod->assign('FILE', $thisfile);
			$mod->assign('PIC', mypicture($thisfile['myfile'], 'small'));
			$mod->parse('module.files.file.picture');
		}
		$mod->assign('filecount', $tel);
		$mod->parse('module.files.file');
	}
	if($numberOfFiles) {
		$mod->assign('upload_max_filesize', ini_get('upload_max_filesize'));
		$mod->parse('module.files');
	}
}

function geticon($ext) {
	$imgExtensions = array('jpg','jpeg','png','gif');
	$ext = strtolower($ext);
    $icondir = BASEPATH.ICONS;
    $iconTable = $GLOBALS['iconTable'];
    if(isset($iconTable[$ext])) {
        if(is_readable($icondir.$iconTable[$ext])) {
            return $iconTable[$ext];
        } else {
            $_SESSION['messages'][] = "no icon: ".$iconTable[$ext];
        }
    } else if(in_array($ext, $imgExtensions)){
		return "THUMB";
    } else {
		if(isset($iconTable['default'])){
	        return $iconTable['default'];
		} else {
			return false;
		}	
    }
}

function savefile($filearray, $filetable, $allowedExtentions = array()) {
	global $mydb;
	$d = array();
	if(!isset($filearray['name'])){
		return false;
	}
	if(isset($filearray['subscript'])) {
		$d['subscript'] = $filearray['subscript'];
	}
	$name = $filearray['name'];
	# no file
	if($_FILES[$name]['name'] == '') {
		# update subscript
		if(isset($filearray['subscript'])) {
			$query = "update $filetable set subscript = '".$filearray['subscript']."' where num = '".(int)$filearray['num']."' and item_id = '".(int)$filearray['item_id']."'";
			$mydb->executeQuery($query);
		}
		return False;
	}
	$d['item_id'] = (int)$filearray['item_id'];
	if(isset($filearray['type'])) {
		$d['type'] = $filearray['type'];
	}
	$d['num'] = (int)$filearray['num'];
	if ($_FILES[$name]['name'] != '') {
		$fileparts = pathinfo($_FILES[$name]['name']);
		$extention = strtolower($fileparts['extension']);
		if (count($allowedExtentions) <= 0 or !in_array($extention, $allowedExtentions)){
			$_SESSION['messages'][] = "The filetype of this file is not allowed: " . $_FILES[$name]['name'];
			return false;
		}
		$newfile = saveupload($name);
		if(!$newfile) {
			#upload went wrong
			$_SESSION['messages'][] =  $GLOBALS['message'];
			return False;
		}

		$d['myfile'] = $newfile;
		$src = BASEPATH.UPLOADS_DIR.$newfile;
		$d['filesize'] = filesize($src);
		# insert in fotos
		#$photo_id = $mydb->insertRecord($d, $phototable);
	} else {
		$d['myfile'] = '';
	}
	$mydb->replaceRecord($d, $filetable);
	return $newfile;
}

function savephoto($filearray, $filetable, $allowedExtentions = array()) {
	global $mydb;
	$newfile = savefile($filearray, $filetable, $allowedExtentions);
	if($newfile) {
		# extra photo check
		$srcpic = BASEPATH.UPLOADS_DIR.$newfile;
		$mypic = new PICTURE($srcpic);
		if($mypic->error_is_set) {
			$_SESSION['messages'][] = $mypic->messages[0];
			$d['myfile'] = '';
			$d['item_id'] = (int)$filearray['item_id'];
			$d['num'] = (int)$filearray['num'];
			$mydb->replaceRecord($d, $filetable);
			return False;
		}
	} else {
		return False;
	}
	
	return True;
}

function saveupload($thisfile='myfile') {
	global $_FILES;
	# check if file doesn't exists
	# if so, append suffix
	#
	if ($_FILES[$thisfile]['name'] == '') {
		return False;
	}
	
	if(defined('MAX_FILE_SIZE') && $_FILES[$thisfile]['size'] > MAX_FILE_SIZE) {
		$GLOBALS['message'] = "sorry, file is te groot! ".$_FILES[$thisfile]['size']." > ".MAX_FILE_SIZE;
		return False;
	}
	if(strlen($_FILES[$thisfile]['name']) > MAX_FILENAME_LENGTH ) {
		$GLOBALS['message'] = "sorry, filenaam is te lang!";
		return False;
	}
	$dstfile = str_replace(" ","_", strtolower(basename($_FILES[$thisfile]['name'])));
	$dstfile = ereg_replace("[!@#$%^&*\(\),']","", $dstfile);
	$dstdir = BASEPATH . UPLOADS_DIR;
	if(file_exists($dstdir . $dstfile)) {
		$fileparts = pathinfo($dstfile);
		$n = 1;
		$newdstfile = newdstfile($dstfile, $fileparts['extension'], $n);
		while (file_exists($dstdir . $newdstfile)) {
			$newdstfile = newdstfile($dstfile, $fileparts['extension'], $n);
			$n++;
		}
		$dstfile = $newdstfile;
	}
	if(!move_uploaded_file($_FILES[$thisfile]['tmp_name'], $dstdir . $dstfile)) {
		$GLOBALS['message'] = "sorry, upload mislukt";
		return False;
	}
	if(filesize($dstdir . $dstfile) == 0) {
		$GLOBALS['message'] = "sorry, upload mislukt(2)";
		return False;
	}
#	mypicture($dstfile, 'small'); # wat nou als het geen pica is!
	chmod($dstdir.$dstfile, 0664);
	return $dstfile;
}
function newdstfile($dstfile, $ext, $n) {
	return basename($dstfile, '.'.$ext) . "_$n." . $ext;
}

function gethumansize($size) {
	$units = array(' B', ' KB', ' MB', ' GB', ' TB');
	for ($i = 0; $size > 1024; $i++) { 
		$size /= 1024; 
	}
	return round($size, 2).$units[$i];
}

function parseSelectOptions($mod, $options, $selectedOption, $templatePath) {
    foreach ($options as $key => $value) {
        $module = array();
		if(is_array($value)){
			if(isset($value['otherData'])){
	        	$module['otherData'] = $value['otherData'];
			}

	        $value = $value['value'];
		}
	
        if ($selectedOption == $value) {
            $module['selected'] = "SELECTED";
        } else {
            $module['selected'] = "";
        }
	    $module['value'] = $value;
        $module['text'] = $key;
        $mod->assign('OPTION', $module);
        $mod->parse($templatePath);
    }
}

function jump($target){
	session_write_close();
	header('Location: '. $target);
	exit;	
}

function autojump(){
	session_write_close();
	if(isInAdmin()){
		jump(URL_BASE  . ADMIN_BASE);
	} else {
		jump(URL_BASE);
	}
}

function isInAdmin() {
	if(isset($_SERVER['SCRIPT_FILENAME'])) {
		$uri = $_SERVER['SCRIPT_FILENAME'];
	}else if(isset($_SERVER['SCRIPT_URI'])) {
		$uri = $_SERVER['SCRIPT_URI'];
	} else {
		$uri = '/';
	}
	return strpos($uri, ADMIN_BASE);
}

function swapArray($Array){
    $Values = array();
    while(list($Key,$Val) = each($Array))
        $Values[$Val] = $Key;
    return $Values;
}

function getSvnRevision($path){
	$svn = File($path. '.svn/entries');
	if(stripos($svn[2], "xml") != false) {
		$svnrev = substr($svn[4], 18);	
		return substr($svnrev,0,  strlen($svnrev)-2);
	} else {
		return $svn[3];	
	}
}

function addSlashesToArray(&$arr) {
	if ( !is_array ( $arr ) ) return;
	
	foreach ( $arr as $key => $val )
		is_array ( $arr[$key] ) ? addSlashesToArray ( $arr[$key] ) : ( $arr[$key] = addslashes ( $arr[$key] ));
}
?>
