<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 24-01-08
 * date modified		: $Id$
 */

define("ERRORFROM","noreply@datact.nl");
define("ERRORTO","bugs@datact.nl");

function userErrorHandler ( $errno, $errmsg, $filename, $linenum,  $vars ) {
    $errorType = array (
               E_ERROR            => 'ERROR',
               E_WARNING        => 'WARNING',
               E_PARSE          => 'PARSING ERROR',
               E_NOTICE         => 'NOTICE',
               E_CORE_ERROR     => 'CORE ERROR',
               E_CORE_WARNING   => 'CORE WARNING',
               E_COMPILE_ERROR  => 'COMPILE ERROR',
               E_COMPILE_WARNING => 'COMPILE WARNING',
               E_USER_ERROR     => 'USER ERROR',
               E_USER_WARNING   => 'USER WARNING',
               E_USER_NOTICE    => 'USER NOTICE',
#               E_STRICT         => 'STRICT NOTICE',
               );

	$time = date( "d M Y H:i:s" );
	
	$mail = new PHPMailer();

	$mail->From     = ERRORFROM;
	$mail->FromName = "Error Reporter";
	$mail->Host     = "localhost";
	$mail->Subject  = "Error reporting: " . BASEPATH;
	$mail->Mailer   = "smtp";
	
	if(isset($errorType[$errno])){
		$body[] = "Error level: " .  $errorType[$errno] . "(Error #:" . $errno . ")";
	} else {
		return;
		$body[] = "Error level: Unknown!";
	}
	$body[] = "Time: " . $time;
	$body[] = "File: " . $filename;
	$body[] = "Message: " . $errmsg;
	$body[] = "Line: " . $linenum;
	$body[] = str_replace("\n", "<br />", "Variables: <pre>" . print_r($vars, true) . "</pre>");
	$body[] = "";
	$body[] = "";

	$bodystring = join("\n", $body);
	$mail->Body    = nl2br($bodystring);
	$mail->AltBody = $body;

	$mail->AddAddress(ERRORTO, "");
	$mail->send();
	$mail->ClearAddresses();
	
	return false;
}

if(defined('DONOT_MAIL_REPORTING') && DONOT_MAIL_REPORTING == False) {
	$old_error_handler = set_error_handler("userErrorHandler");
}
if(DO_ERROR_REPORTING === true){
#	error_reporting(E_ALL ^ E_STRICT);
	error_reporting(E_ALL);
} else {
	error_reporting(0);
}
?>
