<?php

/*
 * Author			: E J Jonkers	
 * company			: DataCT	
 * date created		: 05-10-07
 * date modified	:	 
 */


class MYSQL {

	public $link;
	public $verbose;
	public $quiet;

	function MYSQL($user, $passwd, $db, $host='localhost', $port=3306, $newLink = false) {
		$this->link = @mysql_connect($host.':'.$port, $user, $passwd, $newLink);
		if(!$this->link) {
			echo "connect Error $host:$port / $db";
			return;
		}
		$selectDbResult = mysql_select_db($db, $this->link);
		if(!$selectDbResult) {
			echo "selectDB Error $db $user ";
			return;
		}
	}
	function getTableFields($table) {
		static $cache;

		if(isset($cache[$table])) {
			return $cache[$table];
		}

		$fields = array();
		$result = $this->executeQuery("SHOW COLUMNS FROM $table");
		while ($row = mysql_fetch_object($result)) {
			$fields[] = $row->Field;
		}
		$cache[$table] = $fields;
		return $fields;
	}
	function getRecords($table, $key='all', $value='all', $fields='*', $order=False, $search = array()) {
		# simple select method
		if(!is_array($search)){
			$search = array();
		}
		$query = "SELECT $fields FROM $table ";
		if(strtolower($key) != 'all' and strtolower($value) != 'all') {
			$query .= "WHERE `$key` = '$value' ";
			if(is_array($search)) {
				foreach ($search as $searchkey => $searchvalue){
					if($searchkey == 'FULLQUERY') {
						$query .= $searchvalue;
						break;
					}
					$query .= "AND `$searchkey` like '%$searchvalue%' ";
				}
			}
		} else {
			$first = true;
			if(is_array($search)) {
				foreach ($search as $key => $value){
					if($first){
						if($key == 'FULLQUERY') {
							$query .= "WHERE $value";
							break;
						}
						$query .= "WHERE `$key` like '%$value%' ";
						$first = false;
					} else {
						$query .= "AND `$key` like '%$value%' ";
					}
				}
			}
		}
		if($order) {
			$query .= $order;
		}
		$result = $this->executeQuery($query);
		return $result;
	}
	function getRecordsArray($table, $key='all', $value='all', $fields='*', $order=False) {
		$result = $this->getRecords($table, $key, $value, $fields, $order);
		return $this->convertRecordsToArray($result);
	}

	function convertRecordsToArray($result, $fetchFunction='mysql_fetch_array'){
		$rows = array();
		while ($row = @$fetchFunction($result)) {
			$rows[] = $row;
		}
		return $rows;
	}

	function insertRecord($data, $table) {
		$fields = $this->getTableFields($table);

		foreach($fields as $field) {
			if(!isset($data[$field])) {
				continue;
			}
			if(is_array($data[$field])) {
				continue;
			}
			$val = addslashes($data[$field]);
			$datarow[] = "`$field` = '$val' ";
		}
		$query = "INSERT INTO $table SET ";
		$query .= implode(',', $datarow);

		$this->executeQuery($query);
		$result = mysql_insert_id($this->link);
		return $result;
	}
	function replaceRecord($data, $table) {
		$fields = $this->getTableFields($table);
		foreach($fields as $field) {
			if(!isset($data[$field])) {
				continue;
			}
			$val = addslashes($data[$field]);
			$datarow[] = "`$field` = '$val' ";
		}
		$query = "REPLACE INTO $table SET ";
		$query .= implode(',', $datarow);

		$this->executeQuery($query);
#		$result = mysql_affected_rows($this->link);
		$result = mysql_insert_id($this->link);
		return $result;
	}
	function updateRecord($data, $table, $key, $value) {
		if ($data != array()) {
			$wherestr = "WHERE $key = '$value'";
			return $this->updateRecordWhere($data, $table, $wherestr);
		}
	}
	function updateRecordWhere($data, $table, $where) {
		$fields = $this->getTableFields($table);
		$updatefields = array_keys($data);
		foreach($fields as $field) {
			if(!in_array($field, $updatefields)) {
				continue;
			}
			if(is_array($data[$field])) {
				continue;
			}
			$tval = $data[$field];
			$val = @addslashes($tval);
			$datarow[] = "`$field` = '$val' ";
		}
		$query = "UPDATE $table SET ";
		$query .= implode(',', $datarow);
		$query .= ' '.$where;

		$this->executeQuery($query);
		$result = mysql_affected_rows($this->link);
		return $result;
	}
	function affectedRows() {
		return mysql_affected_rows($this->link);
	}
	function deleteRecord($table, $key='all', $value='all') {
		$query = "DELETE FROM $table";
		if ($key != 'all' && $value != 'all' ) {
			$query .= " WHERE $key = '$value'";
		}

		$this->executeQuery($query);
		$result = mysql_affected_rows($this->link);
		return $result;
	}
	function executeQuery($query) {
//Registering time etc.
global $pagetrack;
isset($pagetrack['sql_query_count']) ? $pagetrack['sql_query_count']++ : "";
$starttime = explode(' ', microtime());
$starttime = $starttime[1] + $starttime[0];
		if($this->verbose) {
			echo "<br><i>query: </i>$query<br>";
		}
		$result = @mysql_query($query, $this->link);
		if(mysql_errno($this->link) and !$this->quiet) {
			$errorString = mysql_error($this->link);
			$string = "Query: \"$query\".  " . $errorString;
			include BASEMODULESPATH."install/updateQueries.inc.php";
			foreach($updateQueries as $errorKey => $updateQuery) {
				if(ereg($errorKey, $errorString)) {
#					$q = str_replace("TABLE", $this->table, $updateQuery);
					$q = $updateQuery;
					$this->executeQuery($q);
				}
			}
			trigger_error($string);
		}

//Registering time etc.
$mtime = explode(' ', microtime());
$totaltime = $mtime[0] + $mtime[1] - $starttime;
isset($pagetrack['sql_query_time']) ? $pagetrack['sql_query_time'][] = round($totaltime,7) . " " . $query : "";
isset($pagetrack['sql_time']) ? $pagetrack['sql_time'] += $totaltime : "";
		return $result;
	}

	public function createTable($tablename, $columns){
		$query = " CREATE TABLE `$tablename` (";
		$no = 0;
		foreach($columns as $column){
			$no++;
			$query .= "`$column` VARCHAR( 255 ) NOT NULL";
			if($no < count($columns)){
				$query .= ",";
			}
		}
		$query .= ") ENGINE = MYISAM;";
		$this->executeQuery($query);
	}

	public function doQuery($query) {
		return $this->convertRecordsToArray($this->executeQuery($query));
	}
}

?>
