<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 13-12-07
 * date modified		: $Id$
 */

class UserManager {
	public static $prefix = "um_";	

	public function __construct(){
	}

	public function getRanges(){
		$ranges = array();
		foreach ($this->getRangeIds() as $rangeId){
			$ranges[] = new Range($rangeId);
		}
		return $ranges;
	}

	public function getRangeIds() {
		global $mydb;
		$result = $mydb->getRecords(UserManager::$prefix . "ranges", "rangeId", 'all', '*', 'order by priority');
		$ids = array();
		while($record = mysql_fetch_array($result)) {
			$ids[] = $record['rangeId'];
		}
		return $ids;
	}

	public function moveRangePosition($itemId, $direction) {
		global $mydb;
		$records = $mydb->getRecordsArray(UserManager::$prefix . "ranges", 'all', 'all', '*', "order by priority");
		$records = reorder($records, $direction, $itemId, 'rangeId');
        foreach($records as $prio => $record) {
            $d = array();
            $d['priority'] = $prio;
            $mydb->updateRecord($d, UserManager::$prefix . "ranges", "rangeId", $record['rangeId']);
        }
	}

	public function hasUser($userId){
		global $mydb;
		$record1 = $mydb->getRecordsArray(UserManager::$prefix . "users", "userId", $userId);
		return (count($record1) > 0);
	}

	public function getCategoryUsers($categoryId){
		$users = array();
		foreach ($this->getUserIds(False, $categoryId) as $userId){
			$users[] = new User($userId);
		}
		return $users;
	}

	public function getUsers($parentId = false){
		$users = array();
		foreach ($this->getUserIds($parentId) as $userId){
			$users[] = new User($userId);
		}
		return $users;
	}

	public function getUserIds($parentId=false, $categoryId=False) {
		global $mydb;
		if(!$parentId){
			$result = $mydb->getRecords(UserManager::$prefix . "users", "userId");
		} 
		if($categoryId) {
			$result = $mydb->getRecords(UserManager::$prefix . "users", "categoryId", $categoryId, "userId");
		}
		if($parentId and !$categoryId) {
			$result = $mydb->getRecords(UserManager::$prefix . "users", "parentUserId", $parentId, "userId");
		}
		$ids = array();
		while($record = mysql_fetch_array($result)) {
			$ids[] = $record['userId'];
		}
		return $ids;
	}

	public function getGroups($userId = false){
		$groups = array();
		foreach ($this->getGroupIds($userId) as $groupId){
			$groups[] = new Group($groupId);
		}
		return $groups;
	}

	public function getGroupIds($userId = false) {
		global $mydb;
		if (!$userId) {
			$result = $mydb->getRecords(UserManager::$prefix . "groups", "groupId");
		} else {
			$result = $mydb->getRecords(UserManager::$prefix . "groups", "parentUserId", $userId, "groupId");
		}
		$ids = array();
		while($record = mysql_fetch_array($result)) {
			$ids[] = $record['groupId'];
		}
		return $ids;
	}

	public function usernameExists($username){
		global $mydb;
		$record = $mydb->getRecordsArray(UserManager::$prefix . "users", "username", $username);
		return count($record) > 0;
	}

	public function getLoggedInUser(){
		if(isset($_SESSION['loggedInUser'])){
			return $_SESSION['loggedInUser'];
		} else {
			$user = $this->getDefaultUser();
			if(!$user){
				return false;
			}
			$_SESSION['loggedInUser'] = $user;
			$_SESSION['defaultUser'] = True;
			return $_SESSION['loggedInUser'];
		}
	}

	public function isLoggedIn(){
		return isset($_SESSION['loggedInUser']);
	}

	public function getDefaultUser(){
		$ip = $_SERVER['REMOTE_ADDR'];
		$ranges = $this->getRanges();
		foreach ($ranges as $range){
			if($range->match($ip)){
				//FIXME Admin user should be logged on instead of guest login.
				return $range->getUser();
			}
		}
		return false;
	}

	// Returns true when the user is logged in automatically, i.e. as guest or based on ip address
	public function isDefaultUser(){
		return (isset($_SESSION['defaultUser']) && $_SESSION['defaultUser']);
	}

	public function logOffUser(){
		if(isset($_SESSION['loggedInUser'])){
			unset($_SESSION['defaultUser']);
			unset($_SESSION['loggedInUser']);
			unset($_SESSION['selectedcat']);
		}
	}

	public function login($username, $password){
		global $mydb;
		$this->logOffUser();
		$login = false;
		$record = $mydb->getRecordsArray(UserManager::$prefix . "users", "username", $username);
		if(count($record) > 0){
			if($record['0']['password'] == $password){
				$user = new User($record['0']['userId']);
				$_SESSION['loggedInUser'] = $user;
				$d = array();
				$d['lastLogin'] = time();
				$mydb->updateRecord($d, UserManager::$prefix . 'users', 'userid', $user->getId());
				$login = true;
			}
		}
		return $login;	
	}
}
?>
