<?php
/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 13-12-07
 * date modified		: $Id$
 */

class User {
	protected $userId;
	private $username;
	private $password;
	private $email;
	private $lastLogin;
	private $changeTime;
	private $group;
	private $groupId = 0;
	private $categoryId = False;
	private $tempPermissions;
	private $parentUserId;
	private $isSuperUser;
	private $isNew = False;
	private	$changedPermissions = False;

	public function __construct($userId = false, $userName = False){
		$this->userId = $userId;
		$this->userName = $userName;
		$this->lastLogin = 0;
		if($userId or $userName){
			$this->getFromDatabase();
		} else {	
			$this->isNew = True;
		}
		$this->tempPermissions = array();
	}

	public function newUser($username, $password, $email, $groupId, $parentUserId){
		$this->userId = false;
		$this->username = $username;
		$this->password = $password;
		$this->email = $email;
		$this->lastLogin = 0;
		$this->group = new Group($groupId);
		$this->parentUserId = $parentUserId;
	}
	public function isNew(){
		return $this->isNew;
	}

	protected function getFromDatabase(){
		global $mydb;
		if($this->userId) {
			$records = $mydb->getRecordsArray(UserManager::$prefix . "users", "userId", $this->userId);
			if(count($records)) {
				$record = $records[0];
			}
		} else {
			$records = $mydb->getRecordsArray(UserManager::$prefix . "users", "username", $this->userName);
			if(count($records)) {
				$record = $records[0];
			}
		}
		if(!isset($record)) {
			return;
		}
		$this->userId = $record['userId'];
		$this->groupId = $record['groupId'];
		$this->username = $record['username'];
		$this->password = $record['password'];
		$this->email = $record['email'];
		$this->lastLogin = $record['lastLogin'];
		$this->parentUserId = $record['parentUserId'];
		$this->isSuperUser = $record['isSuperUser'];
		$this->categoryId = isset($record['categoryId']) ? $record['categoryId'] : False;
		$this->changeTime = isset($record['changeTime']) ? $record['changeTime'] : False;
		$this->group = new Group($record['groupId']);
	}

	public function getTemplateData() {
		$data['userId'] = $this->userId;
		$data['username'] = $this->username;
		$data['password'] = $this->password;
		$data['email'] = $this->email;
		$data['lastLogin'] = date("d-m-Y H:i", $this->lastLogin);
		$data['parentUserId'] = $this->parentUserId;
		$data['groupId'] = $this->group->getId();
		$data['categoryId'] = $this->categoryId;
		$data['changeTime'] = date(DATEFORMAT, $this->changeTime);
		return $data;
	}

	public function save(){
		if(!$this->userId){
			return $this->add();
		} else {
			return $this->update();
		}
	}

	private function add(){
		global $mydb;
		$data = $this->getTemplateData();
		$data['changeTime'] = time();
		# check unique username
		$username = $data['username'];
		$users = $mydb->getRecords(UserManager::$prefix . 'users', 'username', $username, 'userId');
		if(mysql_num_rows($users)) {
			return False;
		}
		$id = $mydb->insertRecord($data, UserManager::$prefix . "users");
		$this->userId = $id;
		foreach($this->tempPermissions as $perm){
			$data = $perm->getTemplateData();
			$data["userId"] = $this->userId;
			$id = $mydb->insertRecord($data, UserManager::$prefix . "user2permissions");
		}
		$this->tempPermissions = array();
		$this->isNew = False;

		return True;
	}

	public function getId(){
		return $this->userId;
	}

	public function delete(){
		global $mydb;
		$data = array();
		$data['parentUserId'] = $this->parentUserId;
		$where = "WHERE parentUserId = '".$this->userId."'";
		$mydb->updateRecordWhere($data, UserManager::$prefix . "users", $where);
		$mydb->updateRecordWhere($data, UserManager::$prefix . "groups", $where);
		$mydb->deleteRecord(UserManager::$prefix . "users", "userId", $this->userId);
		$mydb->deleteRecord(UserManager::$prefix . "user2permissions", "userId", $this->userId);
		$mydb->deleteRecord(UserManager::$prefix . "user2settings", "userId", $this->userId);
	}


	private function update(){
		global $mydb, $available_languages, $contentConf;
		$data = $this->getTemplateData();
		$data['changeTime'] = time();
		$mydb->updateRecord($data, UserManager::$prefix . "users", "userId", $this->userId);

		if($this->changedPermissions) {
			$mydb->deleteRecord(UserManager::$prefix . "user2permissions", "userId", $this->userId);
			foreach($this->tempPermissions as $perm){
				$data = $perm->getTemplateData();
				$data["userId"] = $this->userId;
				$id = $mydb->insertRecord($data, UserManager::$prefix . "user2permissions");
			}
			$this->tempPermissions = array();
		}
		return True;
	}

	public function getName(){
		return $this->username;
	}

	public function getPassword(){
		return $this->password;
	}

	public function setParentUserId($parentUserId){
		$this->parentUserId = $parentUserId;
	}

	public function setusername($username){
		$this->username = $username;
	}

	public function savePassword($password){
		global $mydb;
		$this->password = $password;
		$data = $this->getTemplateData();
		$data['changeTime'] = time();
		$mydb->updateRecord($data, UserManager::$prefix . "users", "userId", $this->userId);
	}
	public function setPassword($password){
		$this->password = $password;
	}

	public function setCategoryId($catId){
		$this->categoryId = $catId;
	}
	public function getCategoryId(){
		return $this->categoryId;
	}
	public function getGroupId(){
		return $this->group->getId();
	}
	public function getGroup(){
		return $this->group;
	}

	public function isSuperUser(){
		return $this->isSuperUser;
	}

	public function setGroup($group){
		$this->group = $group;
	}

	public function getEmail(){
		return $this->email;
	}

	public function setEmail($email){
		$this->email = $email;
	}

	public function hasPermission($categoryId, $permissionName){
		if($this->isSuperUser){
			return true;
		}
		if($categoryId == False) {
			return False;
		}
		$permissions = $this->getPermissionsForCategory($categoryId);
		foreach ($permissions as $perm){
			if($categoryId == $perm->getCategoryId() && $permissionName == $perm->getName() && $perm->getValue() == true){
				return true;
			}
		}
		return false;
	}
	
	public function hasPermissionOnCategory($categoryId){
		global $mydb;
		if($this->isSuperUser){
			return true;
		}
		if($this->checkIfAnyPermissionForCategory($categoryId)) {
			return true;
		}

		$category = new Category($categoryId);
		if(count($category->getPermissions()) == 0 or ($category->isPublic() AND USERENVIROMENT)){
			return true;
		}
		return false;
	}

	public function lastLogingetSetting($identifier, $catIndependent=False){
		foreach ($this->getAllSettings() as $setting){
			$checkIdentifier = $catIndependent ? $setting->getId() : $setting->getIdentificationString();
			if($identifier == $checkIdentifier){
				return $setting;
			}
		}
	}

	public function saveSetting($setting){
		if($setting->isChanged()){
			global $mydb;
			$query = "DELETE FROM um_user2settings WHERE userId = '" .$this->userId. "' AND categoryId = '".$setting->getCategoryId(). "' AND id = '".$setting->getId()."'";
			$mydb->executeQuery($query);
			$data = $setting->getTemplateData();
			$data['userId'] = $this->userId;
			$mydb->insertRecord($data, UserManager::$prefix . "user2settings");
		}
	}

	public function getAllSettings(){
		global $mydb;
		$settings = $this->group->getAllSettings();
		$records = $mydb->getRecordsArray(UserManager::$prefix . "user2settings", "userId", $this->userId);
		foreach ($records as $row){
			foreach($settings as $setting){
				if($setting->getCategoryId() == $row['categoryId'] && $setting->getId() == $row['id']){
					$setting->setValue($row['value']);
					//PREVIOUS SETTING BUG
					$setting->setPreviousValue($row['value']);
				}
			}
		}
		return $settings;
	}
	public function getAllSettingsForCategory($categoryId) {
		$settings = $this->group->getAllSettingsForCategory($categoryId);
		return $settings;
	}
	public function getSettingsArrayForCategory($categoryId = -1){
		$data = array();
		foreach($this->getAllSettingsForCategory($categoryId) as $setting){
			// MOET OOK VOOR ZIJN SUBKINDEREN ALS HET TENMINSTE EEN MULTISHOW IS
			if($setting->getCategoryId() == $categoryId){
				$data[$setting->getId()] = $setting->getValue();
			}
		}
		return $data;
	}

	public function checkIfAnyPermissionForCategory($categoryId){
		global $mydb;
		static $cachedPerms = array();
		static $isCached = False;

		if(isset($cachedPerms[$categoryId])) {
			return True;
		} else if($isCached) {
			return False;
		}

		if($this->groupId) {
			$query = "SELECT categoryId,value FROM um_group2permissions WHERE groupId = '".$this->groupId."' ";
			$result = $mydb->executeQuery($query);
			while($row = mysql_fetch_object($result)) {
				if($row->value == 1) {
					$cachedPerms[$row->categoryId] = $row->value;
				}
			}
		}
#		$query = "SELECT categoryId FROM um_user2permissions WHERE userId = '".$this->userId."' and value = '1'";
		$query = "SELECT categoryId,value FROM um_user2permissions WHERE userId = '".$this->userId."'";
		$result = $mydb->executeQuery($query);
		while($row = mysql_fetch_object($result)) {
			if($row->value == 1) {
				$cachedPerms[$row->categoryId] = $row->value;
			}
		}
		$isCached = True;
		if(isset($cachedPerms[$categoryId]) and $cachedPerms[$categoryId]) {
			return True;
		}
		return False;
	}
	public function getPermissionsForCategory($categoryId){
		global $mydb;
		$groupPermissions = array();
		if(is_object($this->group)) {
			$groupPermissions = $this->group->getPermissionsForCategory($categoryId);
		}
		$userPermissions = array();
		$query = "SELECT * FROM um_user2permissions WHERE userId = $this->userId AND categoryId = '$categoryId' ";
		$result = $mydb->executeQuery($query);

		while($row = mysql_fetch_assoc($result)) {
			$perm = new Permission($row['categoryId'], $row['name'], $row['value']);
			$userPermissions[$perm->getIdentificationString()] = $perm;
		}
		$permissions = array_merge($groupPermissions, $userPermissions);
		return $permissions;
	}
	
	public function getPermissions(){
		global $mydb;
		$groupPermissions = array();
		if(is_object($this->group)) {
			$groupPermissions = $this->group->getPermissions();
		}
		$userPermissions = array();
		$records = $mydb->getRecordsArray(UserManager::$prefix . "user2permissions", "userId", $this->userId);
		foreach ($records as $row){
			$perm = new Permission($row['categoryId'], $row['name'], $row['value']);
			$userPermissions[$perm->getIdentificationString()] = $perm;
		}
		$permissions = array_merge($groupPermissions, $userPermissions);
		return $permissions;
	}

	public function setPermissions($permissions) {
		$categoryManager = new CategoryManager();
		$groupPermissions = $this->group->getPermissions();
		$this->changedPermissions = True;

		//FIXME do niet alle permissies maar alleen alle van de huidige group
		$allPermissions = $categoryManager->getAllPermissions();
		$newPermissions = array();
		//FIXME OF HIJ AL BESTAAT BIJ DE GROUP (OF HIJ HET ZELFDE IS< DAN KILL EM!	
		foreach($permissions as $permission){
			if(isset($groupPermissions[$permission->getIdentificationString()])){
				$newPermissions[$permission->getIdentificationString()] = $permission;
#				echo $permission->getName() . "group wel<BR>";
			}else {
#				echo $permission->getName() . "group NIET<BR>";
				if(isset($allPermissions[$permission->getIdentificationString()])){
					$newPermissions[$permission->getIdentificationString()] = $permission;
#					echo $permission->getName() . "all ECHOWEL<BR>";
				} else {
					//FIXME maar deze user heeft alleen deze permissie, dus toch toevoegen
					$newPermissions[$permission->getIdentificationString()] = $permission;
#					echo $permission->getName() . " all ECHONIET<BR>";
				}
			}
		}
		$this->tempPermissions = $newPermissions;
	}

	public function isDeletable(){
		global $mydb;
		$userManager = new UserManager();
		$cantdeleteyourself = false;
		if($userManager->isLoggedIn() && $userManager->getLoggedInUser()->getId() == $this->userId){
			$cantdeleteyourself = true;	
		}
		$record1 = $mydb->getRecordsArray(UserManager::$prefix . "ranges", "userId", $this->userId);
		return !(count($record1) > 0) && !$cantdeleteyourself;
	}
}
?>
