<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 28-09-07
 * date modified		: $Id: Field.class.php 116 2007-10-12 14:48:11Z ivo $
 */

abstract class Setting  {
	protected $categoryId;
    protected $id;
    protected $name;
    protected $userSetting;
    protected $type;
    protected $default;
    protected $condition;
	protected $neededPermission;
	protected $value;
    protected $previousValue;
	protected $error;

    public function __construct($categoryId, $id, $name, $userSetting, $type, $default, $condition, $neededPermission ,$value='', $comment='') { 
		$this->categoryId = $categoryId;
		$this->id = $id;
		$this->name = $name;
		$this->userSetting = $userSetting;
		$this->type = $type;
		$this->default = $default;
		$this->condition = $condition;
		$this->neededPermission = $neededPermission;
		$this->value = $value;
		$this->previousValue = $value;
		$this->comment = $comment;
		$error = false;
	}

	public function getIdentificationString(){
		return $this->categoryId . ":". $this->id;
	}

    public function getId() { return $this->id; }

    public function getName() { return $this->name; }

    public function isUserSetting() { return $this->userSetting; }

    public function setName($value) { $this->name = $value; }

    public function getType() { return $this->type; }

    public function setType($value) { $this->type = $value; }

    public function getDefault() { return $this->default; }

    public function setDefault($value) { $this->default = $value; }

    public function getCategoryId() { return $this->categoryId; }
    
	public function getCondition() { return $this->condition; }
	
	public function getNeededPermission() { return $this->neededPermission; }

    public function setCondition($value) { $this->condition = $value; }

    public function getPreviousValue() { return $this->value; }

    public function setPreviousValue($value) { $this->previousValue = $value; }

    public function getValue() { return $this->value; }

    public function setValue($value) { 
		if($this->type == 'checkbox') {
			$value = $value == 'True' ? 'True' : 'False';
		}
		$this->value = $value; 
	}

	public function read(){
		if(isset($_REQUEST[$this->fieldName])) {
			$this->value = $_REQUEST[$this->fieldName];
			$this->validate();
		}
	}

	public function validate(){
		if($this->condition) {
			$valid = (preg_match($this->condition, $this->value));
			$this->error = ($valid ? False : True);
		}
	}

	public function isValid(){
		$this->validate();
		return $this->error;
	}

	public function getTemplateData() {
		$data['categoryId'] = $this->getCategoryId();
		$data['id'] = $this->id;
		$data['default'] = $this->default;
		$data['type'] = $this->type;
		$data['name'] = $this->name;
		$data['value'] = $this->value;
		$data['condition'] = $this->condition;
		$data['identificationString'] = $this->getIdentificationString();
		$data['neededPermission'] = $this->neededPermission;
		$data['comment'] = $this->comment;
		return $data;
	}
	
	public function isChanged(){
		return $this->value != $this->previousValue;
	}
}
