<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 30-01-09
 * date modified		: $Id$
 */

class QueuedMail {
	private $mailId;
	private $configuration;
	private $subject;
	private $from;
	private $name;
	private $body;
	private $recipient;
	private $attach1;
	private $attach2;
	private $attach3;
	private $attach4;
	private $attach1name;
	private $attach2name;
	private $attach3name;
	private $attach4name;
	private $mail;
	
	public function __construct($mailId = false, $configuration) {
		$this->configuration = $configuration;
		$this->mail = new PHPMailer();
		$this->mailId = $mailId;
		if($this->mailId){
			$this->getFromDatabase();
		}
	}

	public function getFromDatabase(){
		global $mydb;
		$result = $mydb->convertRecordsToArray($mydb->getRecords($this->configuration['table'], $this->configuration['table_primairykey'], $this->mailId));
		if(count($result)) {
			$record = $result[0];
		}
		$this->mailId = $record['mailId'];
		$this->subject = $record['subject'];
		$this->from = $record['mailFrom'];
		$this->name = $record['mailName'];
		$this->body = $record['body'];
		$this->recipient = $record['recipient'];
		$this->attach1 = $record['attach1'];
		$this->attach1 = $record['attach1name'];
		$this->attach2 = $record['attach2'];
		$this->attach2 = $record['attach2name'];
		$this->attach3 = $record['attach3'];
		$this->attach3 = $record['attach3name'];
		$this->attach4 = $record['attach4'];
		$this->attach4 = $record['attach4name'];
	}

	public function save() {
		if(!$this->mailId){
			return $this->add();
		} else {
			$this->update();
		}	
	}	

	private function add(){
		global $mydb;
		$data = $this->getTemplateData();
		$id = $mydb->insertRecord($data, $this->configuration['table']);
		return True;
	}

	private function update() {
		global $mydb;
		$data['isSend'] = $this->isSend;
		$mydb->updateRecordWhere($data, "mq_mailerqueue", "WHERE mailId = " . $this->mailId);
	}

	public function getTemplateData(){
		$data = array();
		$data['subject'] =   $this->subject;
		$data['mailName'] =   $this->name;
		$data['mailFrom'] =   $this->from;
		$data['body'] =      $this->body;
		$data['recipient'] = $this->recipient;
		$data['attach1'] =   $this->attach1;
		$data['attach1name'] =   $this->attach1name;
		$data['attach2'] =   $this->attach2;
		$data['attach2name'] =   $this->attach2name;
		$data['attach3'] =   $this->attach3;
		$data['attach3name'] =   $this->attach3name;
		$data['attach4'] =   $this->attach4;
		$data['attach4name'] =   $this->attach4name;
		return $data;
	}

	public function newQueuedMail($subject, $from, $name, $body, $recipient, $attach1, $attach2, $attach3, $attach4, $attach1name, $attach2name, $attach3name, $attach4name) {
		$this->subject =   $subject;
		$this->from =   $from;
		$this->name =   $name;
		$this->body =      $body;
		$this->recipient = $recipient;
		$this->attach1 =   $attach1;
		$this->attach1name =   $attach1name;
		$this->attach2 =   $attach2;
		$this->attach2name =   $attach2name;
		$this->attach3 =   $attach3;
		$this->attach3name =   $attach3name;
		$this->attach4 =   $attach4;
		$this->attach4name =   $attach4name;
	}

	public function send(){
		$this->addAttachement($this->attach1, $this->attach1name);
		$this->addAttachement($this->attach2, $this->attach2name);
		$this->addAttachement($this->attach3, $this->attach3name);
		$this->addAttachement($this->attach4, $this->attach4name);
		$this->mail->Priority = $this->configuration['priority'];
		$this->mail->Encoding = $this->configuration['encoding'];
		$this->mail->CharSet =  $this->configuration['charset'];
		$this->mail->From =     $this->from;
		$this->mail->FromName = $this->name;
		$this->mail->Sender =   $this->from;
		$this->mail->Subject =  $this->subject;
		$this->mail->Body =  $this->body;
		$this->mail->AltBody = strip_tags($this->body);
		$this->mail->ClearAllRecipients();
		$this->mail->AddAddress($this->recipient);
#		$this->mail->AddAddress("ivo@cetivo.com");
		$this->mail->Mailer = "mail";
		$result = $this->mail->Send();
//		echo $this->mail->ErrorInfo;
//		echo $result;
		if($result){
			$this->isSend = true;
			$this->save();
		}
		return $result;
	}

	private function addAttachement($attachment, $name){
		if($attachment <> "") {
			if(file_exists($attachment)){
				$this->mail->AddAttachment($attachment, $name);
			}
		}
	}
}
?>
