<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 08-11-07
 * date modified		: $Id$
 */

class ProgressBar{

	private $name;
	private $min;
	private $max;
	private $current;
	
	public function __construct($name, $min = false, $max = false) {
		global $mydb;
		$this->name = $name;

		if(!($min === false and $max === false)){
			$this->clearSession();
			$this->min = $min;
			$this->max = $max;
			$this->current = 0;
			$this->saveInSession();
		} else {
			$this->loadFromSession();
		}
	}

	public function getPercentage(){
		if($this->current > 0){
			return round(($this->current/$this->max)*100);
		} else {
			return 0;
		}
	}
	
	public function raiseCurrentLevel(){
		$this->current++;
		$this->saveInSession();
	}

	private function clearSession(){
		global $mydb;
		$query = "DELETE FROM `Progressbars` WHERE `id` = '" .$_COOKIE[ADMINSESSIONNAME]."' and `name` = '".$this->name."';";
		$result = $mydb->executequery($query);
	}

	private function saveInSession(){
		global $mydb;
		$d['id'] = $_COOKIE[ADMINSESSIONNAME];
		$d['name'] = $this->name ;
		$d['min'] = $this->min;
		$d['max'] = $this->max;
		$d['current'] = $this->current;
		$d['creationtime'] = time();
		$result = $mydb->replaceRecord($d, "Progressbars");
	}

	private function loadFromSession(){
		global $mydb;
		$query = "SELECT * FROM Progressbars WHERE id = '".$_COOKIE[ADMINSESSIONNAME]."' and name = '".$this->name."'";
		$result = $mydb->executequery($query);
		$rows = array();
		while ($row = @mysql_fetch_array($result)) {
			$rows[] = $row;
		}

		$this->min = $rows[0]['min'];
		$this->max = $rows[0]['max'];
		$this->current = $rows[0]['current'];
	}
}
?>
