<?php

/*
 * Author			: E J Jonkers    
 * company			: DataCT    
 * date created		: 05-10-05
 * date modified	:     
 */

# init met eerste arg volledige img pad
# methods:
#  -setwidth
#  -setheight 
#  -keepaspect (keep aspect ratio [boolean] default true)
#  -show
#  -save
# verkleint naar kleinste waarde breedte of hoogte
# vergroot naar grootst mogelijke waarde

define('MAXPIXWIDTH', 4000);
define('MAXPIXHEIGHT', 4000);

#All types: 1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF, 5 = PSD, 6 = BMP, 7 = TIFF(intel byte order), 8 = TIFF(motorola byte order), 9 = JPC, 10 = JP2, 11 = JPX, 12 = JB2, 13 = SWC, 14 = IFF, 15 = WBMP, 16 = XBM
$supporttypes= array(1 => 'gif', 2 => 'jpg', 3 => 'png');


class PICTURE {
	public $width 				= 0;
	public $newwidth 			= 0;
	public $height 			= 0;
	public $newheight			= 0;
	public $setwidth			= 0;
	public $setheight			= 0;
	public $source_img_file;
	public $quality				= 75;
	public $imgdatadest;
	public $imgdatasrc;
	public $type;
	public $keepaspect 		= True;
	public $debug 				= False;
	public $error_is_set 		= False;

	function PICTURE($sourcefile, $quality = 75) {
		$this->quality = $quality;
		if(!file_exists($sourcefile)) {
			$this->messages[] = "source file is not there/readable/noimg: $sourcefile";
			$this->error_is_set = True;
			return;
		}
		$imgdata = getimagesize($sourcefile);
		if (!$imgdata) {
			# source file is not there/readable
			$this->messages[] = "source file is not there/readable/noimg: $sourcefile";
			$this->error_is_set = True;
			return;
		}

		$this->source_img_file = $sourcefile;
		$this->width = $imgdata[0];
		$this->height = $imgdata[1];

		if($this->width > MAXPIXWIDTH) {
			$this->messages[] = "width too wide: ".$this->width." > ".MAXPIXWIDTH." file:$sourcefile";
			$this->error_is_set = True;
			return;
		}

		if($this->height > MAXPIXHEIGHT) {
			$this->messages[] = "height too high: ".$this->height." > ".MAXPIXHEIGHT." file:$sourcefile";
			$this->error_is_set = True;
			return;
		}

		if(!$this->checktype($imgdata[2])) {
			$this->messages[] = "unsupported img type: $sourcefile";
			$this->error_is_set = True;
			return;
		}
	}
	function setWidth($newwidth) {
		$this->newwidth = abs((int)$newwidth);
	}
	function setHeight($newheight) {
		$this->newheight = abs((int)$newheight);
	}
	function keepAspect($ka=True) {
		$this->keepaspect = ($ka ? True : False);
	}
	function outputType($newtype) {
		$this->setpublishtype($newtype);
		$this->type = $newtype;
	}
	function show() {
		$this->publish();
	}
	function save($destinationfile, $doResize=true) {
		$path = dirname($destinationfile);
		if (!is_writeable($path)) {
			$this->messages[] = "no dir like or it's not writeable (chmod 777): $path";
		}
#		if (!is_writable($destinationfile)) {
#			$this->messages[] = "no dir like or it's not writeable (chmod 777): $path";
#		}
		$this->publish($destinationfile, $doResize);
		# output as file;
	}

	function publish($outputfile=False, $doResize=true) {
		$this->calculate_newsize();
		if ($this->debug) {
			$this->print_messages();
			exit();
		}
		if($doResize){
			$this->doresize();
		}

		$func = $this->publish_function;
		if(!$outputfile) {
			header("Content-Type: image/".$this->type);
			$func($this->imgdatadest, false, $this->quality);
		} else {
			$func($this->imgdatadest, $outputfile, $this->quality);
		}
		imagedestroy($this->imgdatasrc);
		imagedestroy($this->imgdatadest);
		# output as picture, set html headers etc..
	}

	function doresize() {
		$this->imgdatadest = ImageCreateTrueColor($this->setwidth, $this->setheight);
		imagecopyresampled($this->imgdatadest, $this->imgdatasrc, 0, 0, 0, 0, 
			$this->setwidth, $this->setheight, $this->width, $this->height);
	}
	
	function calculate_newsize() {
		# calculate new size if keep aspectratio is True
		# breedte is dominant over de hoogte
		# bij verkleining wordt de breedte aangehouden mits de hoogte kleiner
		# is aan de nieuwe hoogte
		# bij vergroting wordt alleen gekeken naar de breedte.

		$nw = $this->newwidth;
		$w = $this->width;
		$nh = $this->newheight;
		$h = $this->height;

		if(!$this->keepaspect) {
			$this->setwidth = (int)($nw ? $nw : $w);
			$this->setheight = (int)($nh ? $nh : $h);
			return;
		}

		if ($nw and $nh) {
			$factor = $nw / $w;
			$nnh = $factor * $h;
			$nnw = $nw;
			
			if ($factor < 1) {
				# verkleinen
				if ($nnh > $nh ) {
					#img stil too big
					$factor = $nh / $h;
					$nnw = $factor * $w;
					$nnh = $nh;
				}
			} elseif ($nnh > $nh ) {
				$factor = $nh / $h;
				$nnw = $factor * $w;
				$nnh = $nh;
			}
		} else if ($nw and !$nh) {
			$factor = $nw / $w;
			$nnh = $factor * $h;
			$nnw = $nw;
		} else if (!$nw and $nh) {
			$factor = $nh / $h;
			$nnw = $factor * $w;
			$nnh = $nh;
		} else {
			$nnw = $w;
			$nnh = $h;
		}
		$this->setwidth = (int)$nnw;
		$this->setheight = (int)$nnh;
	}
	function checktype($thistype) {
		global $supporttypes;
		foreach($supporttypes as $typeid => $type) {
			if ($thistype == $typeid) {
				$this->type = $type;
				$this->setpublishtype($type);
			    switch($type) {
        			case 'jpg':
		    	        $this->imgdatasrc = imagecreatefromjpeg($this->source_img_file);
            		break;
			        case 'png':
		    	        $this->imgdatasrc = imagecreatefrompng($this->source_img_file);
		            break;
			        case 'gif':
		    	        $this->imgdatasrc = imagecreatefromgif($this->source_img_file);
		            break;
			    }
				return True;
			}
		}
		return False;
	}
	function setpublishtype($type) {
	    switch($type) {
			case 'jpg':
		        $this->publish_function = 'Imagejpeg';
    		break;
	        case 'png':
		        $this->publish_function = 'Imagepng';
				$this->quality = 9 - round($this->quality/100 * 9);
            break;
	        case 'gif':
		        $this->publish_function = 'Imagegif';
            break;
	    }
	}

	function print_messages() {
		if(count($this->messages)) {
			foreach($this->messages as $message) {
				echo $message."<br>";
			}
		}
		echo "width:".$this->width." newwidth:".$this->newwidth." setwidth:".$this->setwidth."<br>";
		echo "height:".$this->height." newheight:".$this->newheight." setheight:".$this->setheight."<br>";
		echo "publish_function: ".$this->publish_function."<br>";
		echo "since debug is true no real header/imgdata is printed<br>";
	}
	
	function rotate($degree){
		$image = $this->imgdatasrc;
		if($image){
			$this->imgdatadest = imagerotate($image, $degree, 0);
			$this->save($this->source_img_file, False);
		} else {
			$_SESSION['messages'][] = "Rotation error";
		}
	} 
}
?>
