<?php
/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 30-10-07
 * date modified		: $Id$
 */
class Listing {
	private $records			= array();
	private $headerArray		= array();
	private $pageSize 			= 20;
	private $filters 			= array();
	private $noSorting 			= False;
	public  $defaultOrder		= False;
	public  $defaultOrderDirection		= False;
	private $var                = Array();

	public function setPageSize($pageSize){
		if($pageSize > 0) {
			$this->pageSize = $pageSize;
		}
	}
	public function setNoSorting(){
		$this->noSorting = True;
	}
	public function addRecord($record){
		$this->records[] = $record;
	}
	public function count(){
		return count($this->getRecords());
	}
	public function orderRecords($field = false, $direction = false) {
		if(count($this->getHeader()) > 0 and !$field and !$this->noSorting){ 
			$field = array_shift($this->getHeader());
		}
		if($field) {
#echo $field;
			$newRecords = array();
			foreach($this->records as $record) {
				$newRecords[] = $record[$field];
			}

			if($direction != "down"){
				asort($newRecords);
			} else {
				arsort($newRecords);
			}

			$sortedRecords = array();
			foreach($newRecords as $key => $value) {
					$sortedRecords[] = $this->records[$key];
			}

			$this->records = $sortedRecords;
		}
		return $this->getRecords();
	}
	public function setDefaultSort($order, $direction) {
		$this->defaultOrder = $order;
		$this->defaultOrderDirection = $direction;
	}
	public function setVar($var) {
		$this->var = $var;
	}
	public function getVar(){
		return $this->var;
	}
	
	public function getPagedRecords($page = 1) {
		$pagedResults = array();
		$number = 1;
		$minNumber = (($page) * $this->pageSize) - $this->pageSize;
		$maxNumber = (($page) * $this->pageSize);
		foreach($this->getRecords() as $record) {
			if($number <= $maxNumber && $number > $minNumber){
				$pagedResults[] = $record;
			}
			$number ++;
		}
		return $pagedResults;
	}

	public function getNumberOfPages(){
		$records = $this->getRecords();
		if(count($records)){
			return ceil(count($records) / $this->pageSize);
		} else {
			return 0;
		}
	} 

	public function addFilter($field, $value) {
		$this->filters[$field] = $value;
	}

	public function resetFilter() {
		$this->filters = array();
	}

	public function getHeader() {
		$records= $this->records;
		if(count($records)){
			$array = array();
			foreach (array_keys($records[0]) as $key){
				if(!is_integer($key)){
					$array[]=$key;
				}
			}
			return $array;
		} else {
			return array();
		}
	}
	
	public function getRecords() {
		$filteredRecords = array();
		foreach($this->records as $record) {
			$add = true;
			foreach($this->filters as $field => $value){
				if(!(isset($record[$field]) && $record[$field] == $value)){
					$add = False;
					break;
				}
			}
			if($add){
				$filteredRecords[] = $record;
			}
		}
		return $filteredRecords;
	}

	public function getPageSize() {
		return $this->pageSize;
	}
}
?>
