<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 30-10-07
 * date modified		: $Id$
 */

class Csv {
	private	$XLS2CSV 			= "/www/bin/xls2csv";
	private $linebuffer			= array();
	
	private $records			= array();
	private $headerArray		= array();
	private $delimiter			= ',';
	private $fieldquote			= '"';
	private $newline  			= "\r\n";
	private $filename  			= "report";

	public $errors = array();

	public function setFilename($filename){
		$this->filename = $filename;
	}
	public function getDocument(){
		$documentString = $this->getDocumentString();
	    $length = strlen($documentString);

	    header("Content-type: application/application/x-msexcel");
    	header("Content-Length: $length");
	    header("Content-Disposition: inline; filename=".$this->filename.".csv");
	    print $documentString;
	}

	public function parseCsvFile($infile, $hasHeader = false) {
		$data = array();
		$isXlsFile = False;
		$pathinfo = pathinfo($infile);
		$extention  = $pathinfo['extension'];

		if($extention == 'xls' and is_executable($this->XLS2CSV)) {
			$isXlsFile = True;
		    if(file_exists($infile)) {
				$tmpFile = tempnam(BASEPATH.UPLOADS_DIR, 'CSV_');
   				$cmd = $this->XLS2CSV." ".$infile;
				exec($cmd, &$data);
				$tf = fopen($tmpFile, 'w');
				foreach($data as $line) {
					fwrite($tf, $line."\n");
				}
				fclose($tf);
				unset($data);
				$infile = $tmpFile;
			}
		}

		$dh = fopen($infile, 'r');
		if($dh === FALSE) {
			$this->errors[] = "ERROR opening $infile";
			return;
		}

		$firstLine = true;
		while(($record = fgetcsv($dh, 0, $this->delimiter, $this->fieldquote)) !== FALSE) {
			if($hasHeader and $firstLine) {
				$this->headerArray = $record;
			} else {
				$this->addRecord($record);
			}
			$firstLine = false;
		}
	}

	public function getHeader(){
		return $this->headerArray;
	}

	public function saveDocument($destinationFile, $fileopenoption='w') {
		$file = @fopen($destinationFile, $fileopenoption);
		if(!$file) {
			$this->errors[] = "ERROR opening $destinationFile for writing";
			return;
		}
		
		fwrite($file, $this->getDocumentString());
		fclose($file);
	}

	private function getDocumentString(){
		$documentString = "";
		if(count($this->headerArray)>0){
			$documentString .= $this->getRecordString($this->headerArray);
		}
		foreach ($this->records as $record){
			$documentString .= $this->getRecordString($record);
		}
		return $documentString;
	}

	private function getRecordString($record) {
		$dlm = $this->fieldquote.$this->delimiter.$this->fieldquote;
		return $this->fieldquote. @implode($dlm, $record) .$this->fieldquote.$this->newline;
	}

	public function addRecord($record){
		$this->records[] = $record;
	}

	public function setHeader($headerArray){
		$this->headerArray = $headerArray;
	}

	public function setDelimiter($dlm) {
		$this->delimiter = $dlm;
	}

	public function setFieldQuote($dlm) {
		$this->fieldquote = $dlm;
	}
	
	public function getErrors() {
		return $this->errors;
	}

	public function hasErrors() {
		return count($this->errors)>0;
	}	
	public function getRecordsAssoc() {
		$returnRecords = array();
		foreach($this->records as $record) {
			$returnRecord = array();
			foreach($record as $num => $value) {
				$field = $this->headerArray[$num];
				$returnRecord[$field] = $value; 
			}
			$returnRecords[] = $returnRecord;
		}
		return $returnRecords;
	}
	public function getRecords() {
		return $this->records;
	}
}
?>
