<?php
/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT	
 * date created			: 28-09-07
 * date modified		: $Id: Content.class.php 172 2007-10-25 07:55:23Z ivo $
 */

class Content {
	private $itemId; 			//key
	private $categoryId;
	private $addTime;
	private $changeTime;
	private $prio;
	private $hide;
	private $fields = array();
	public  $isNew;
	private $language;
	private $content_table = 'content';
	private $content_texts_table = false;
	private $table_primairykey = 'itemId';
	private $listTitleField = 'title';
	private $files;
	private $validateError = False;
	private $errorFields = array();
	private $urlName;
	private $contentConf;
	private $uniqueKeyFields = array();
	private $allowDuplicate = false;

	public function __construct($itemId = false, $configPath = false, $contentConf = false){
		global $mydb;
		if(($configPath and file_exists($configPath)) and !$contentConf){
			include($configPath);
			$this->contentConf = $contentConf;
		} else if ($configPath){
			echo "CONFIG FILE DOESNT EXIST! ($itemId, $configPath)";
#			exit;
		}
		if (is_array($contentConf)){
			$this->contentConf = $contentConf;
		} else {
			echo "Geen contentConf ! ($itemId, $configPath)";
			exit;
		}

	
		$this->content_table = $this->contentConf['table'];
		if(isset($this->contentConf['table_texts']) && $this->contentConf['table_texts'] != ''){
			$this->content_texts_table = $this->contentConf['table_texts'];
		}
		$this->table_primairykey = $this->contentConf['table_primairykey'];
		$this->listTitleField = $this->contentConf['listtitle'];
		if(isset($this->contentConf['useParentCatIdForSelectedCat'])){
			$this->useParentCatIdForSelectedCat = ($this->contentConf['useParentCatIdForSelectedCat'] ? True : False);
		} else {
			$this->useParentCatIdForSelectedCat = false;
		}

		$this->setLanguage(getSelectedLanguage());
		$contentConf = $this->contentConf;
		$configFields = $contentConf['fields'];
		foreach($configFields as $fieldName => $configField) {
			if(!isset($configField['type'])){
				$type = "text";
			} else {
				$type = $configField['type'];
			}
			if(!isset($configField['preProcessFunctions']) or !is_array($configField['preProcessFunctions'])){
				$preProcessFunctions = array();
			} else {
				$preProcessFunctions = $configField['preProcessFunctions'];
			}
			if(!isset($configField['languageDependent'])) {
				$configField['languageDependent'] = False;
			}
			if($configField['languageDependent']){
				$field = new LanguageDependentField($fieldName, $configField['defaultValue'], $configField['condition'], $configField['languageDependent'], $configField['defaultValue'], $type, $preProcessFunctions);
			} else {
				if($type == 'list'){
					$field = new ListField($fieldName, $configField['defaultValue'], $configField['condition'], $configField['languageDependent'], array(), $type, $configField['listWithConfig']);
				}else if($type == 'date'){
					$field = new DateField($fieldName, $configField['defaultValue'], $configField['condition'], $configField['languageDependent'], $configField['defaultValue'], $type, $preProcessFunctions, $configField['dateformat']);
				}else if($type == 'select'){
					$selectOptions = isset($configField['selectOptions']) ? $configField['selectOptions'] : False;
					$selectContentConfig = isset($configField['selectContentConfig']) ? $configField['selectContentConfig'] : False;
					$field = new SelectField($fieldName, $configField['defaultValue'], $configField['condition'], $configField['languageDependent'], $configField['defaultValue'], $type, $selectOptions, $selectContentConfig);
				}else {
					$field = new NormalField($fieldName, $configField['defaultValue'], $configField['condition'], $configField['languageDependent'], $configField['defaultValue'], $type, $preProcessFunctions);
				}
			}
			$this->fields[$field->getFieldName()] = $field;
		}
		$this->itemId = $itemId;	
		$this->isNew = ($itemId == False ? True : False);
		
		$this->files = array();
		if(!$this->isNew){
			$this->getContentFromDatabase();
		} else {
			if(isset($contentConf['insertAtTop']) && $contentConf['insertAtTop']) {
				$this->setPrio(-99999);
			} else {
				$this->setPrio(99999);
			}
		}
		if(isset($this->contentConf['uniqueKey'])) {
			$this->uniqueKeyFields = split(',', $this->contentConf['uniqueKey']);
		}

	}
	public function getConfigValue($configName) {
		if(isset($this->contentConf[$configName])) {
			return $this->contentConf[$configName];
		}
		return NULL;
	}

	public function getFields(){
		return $this->fields;
	}

	public function getFile($num){
		foreach($this->getFiles() as $file) {
			if ($file['num'] == $num) {
				return $file;
			}
		}
	}
	public function getFiles(){
		return $this->files;
	}

	public function hasError(){
#		return $this->files; ???
	}

	public function setCategoryId($categoryId) {
		if($categoryId > 0) {
			if($this->useParentCatIdForSelectedCat) {
				$categoryManager = new CategoryManager();
				$categoryId = $categoryManager->getParentIdFromId($categoryId);
				unset($categoryManager);
			}
			$this->categoryId = $categoryId;
		}
		// else keep current categoryId
	}
	public function getCategoryId() {
		return $this->categoryId;
	}

	public function hasValidateError() {
		return $this->validateError;
	}

	public function getErrorFields() {
		return $this->errorFields;
	}

	public function readFromForm(){
		$this->validateError = False;
		foreach($this->fields as $field) {
			$field->read();
			if($field->error) {
				if(!in_array($field->getFieldName(), $this->errorFields)) {
					$this->errorFields[] = $field->getFieldName();
				}
				$this->validateError = True;
			}
		}
		if($this->validateError) {
			return False;
		}
		if($this->contentConf['number_of_files'] > 0){
	   		if(isset($_POST['files']) && is_array($_POST['files'])){
				$postFiles = $_POST['files'];
				foreach($postFiles as $num => $file) {
					$file['num'] = $num;
					$file['name'] = "myfile".$num;
					$file['itemId'] = 0;
					if(isset($_POST['filetitles'][$num])) {
						$file['subscript'] = $_POST['filetitles'][$num];
					}
					$this->files[$num] = $file;
				}
			}
		}
		return True;
	}

	public function validateFields($fieldNames= array(), $resetFields=False){
		global $contentConf;
		if($resetFields) {
			$this->errorFields = array();
		}
		foreach($this->fields as $field) {
			$field->read();
			if(in_array($field->getFieldName(), $fieldNames) or count($fieldNames) == 0){
				$field->validate();
				if($field->error) {
					$this->errorFields[] = $field->getFieldName();
				}
			}
		}
		return count($this->errorFields) == 0;
	}

	public function deleteFile($num){
		global $mydb;
		$f = $this->getFile($num);
		$fullPath = BASEPATH.UPLOADS_DIR.$f['myfile'];
		if(file_exists($fullPath)) {
			unlink($fullPath);
		}
		//TODO:delete/unlink file from harddrive
		$query = "delete from ".$this->contentConf['table_files']." where num = '".$num."' and item_id = '".$this->itemId."'";
		$mydb->executeQuery($query);
		$this->getFilesFromDatabase();
	}

	public function getItemId() {
		return $this->itemId;
	}
	public function setLanguage($language) {
		if($language == '') {
			$language = DEFAULT_LANGUAGE;
		}
		$this->language = $language;
	}
	private function checkUnique() {
		global $mydb;
		if(!count($this->uniqueKeyFields) or !$this->isNew) {
			return True;
		}
		# get values that will be saved;
		$valuesToCheck = array();
		foreach($this->uniqueKeyFields as $fieldName) {
			$valuesToCheck[] = sprintf("%s = '%s'",$fieldName, $this->getValue($fieldName));
		}
		$query = sprintf("select %s from %s where %s", $this->table_primairykey, $this->content_table, join(' and ', $valuesToCheck));
		$result = $mydb->executeQuery($query);
		if(mysql_num_rows($result)) {
			# yes already in there! not unique!
			$this->errorFields[] = "duplicateEntry";
			return False;
		}
		return True;
	}

	public function parseAndSave() {
		if($this->readFromForm()) {
			# als er geen uniqueKeyFields is geset returnt checkUnique True;
			return $this->save();
		}
		return false;
	}
	public function save(){
		if($this->isNew){
			if($this->allowDuplicate || $this->checkUnique()) {
				$this->setAddTime();
				$return = $this->add();
				$this->saveUrlname();
				return $return;
			} 
			return False; # not unique!
		} else {
			$this->saveUrlname();
			return $this->update();
		}
	}

	public function setFieldValue($fieldName, $value){
		$field = $this->fields[$fieldName];
		$field->setValue($value);
	}

	public function getDataArray(){
		$data = array();
		$keyValuePairs = array();

		foreach($this->fields as $field) {
			$thisFieldName = $field->getFieldName();
			if($field->isLanguageDependent()){
				$keyValuePairs[$thisFieldName] = $field->getValues();
			} else {
				$thisfield = $field->getDataValue();
				if(is_string($thisfield)) {
					$data['radio'][$thisFieldName][$thisfield] = 'checked';
					$data['select'][$thisFieldName][$thisfield] = 'selected';
				}
				$keyValuePairs[$thisFieldName] = $thisfield;
			}
		}

		if(!$this->isNew){	
			$data[$this->table_primairykey] = $this->itemId;
		}
		$data['categoryId'] = $this->categoryId;
		$data['addTime'] = $this->addTime;
		$data['changeTime'] = $this->getChangeTime();
		$data['prio'] = $this->prio;
		$data['hide'] = $this->hide;
		$data['urlName'] = $this->getUrlName();
		$data += $keyValuePairs;
		$data['dataFields'] = serialize($keyValuePairs);
		return $data;
	}

	public  function getUrlName() {
		if ($this->urlName == '') {
			if(trim($this->contentConf['listtitle'] != "" and $this->contentConf['listtitle'] != 'itemId')){
				$field = $this->fields[$this->contentConf['listtitle']];
				if(!is_null($field)){
					if($field->isLanguageDependent()){
						$values = $field->getValues();
						if(isset($values[$this->language])) {
							$this->generateUrlName($values[$this->language]);
						} else if(isset($values[DEFAULT_LANGUAGE])) {
							$this->generateUrlName($values[DEFAULT_LANGUAGE]);
						}
					} else {
						$this->generateUrlName($field->getValue());
					}
				}
			}
		}
		return $this->urlName;
	}
	private function generateUrlName($name) {
		$urlName = str_replace(' ','_', $name);
		$urlName = str_replace(".",'', $urlName);
		$urlName = str_replace("'",'', $urlName);
		$urlName = urlencode($urlName);
		$urlName = ereg_replace("%[0-9A-F][0-9A-F]",'_', $urlName);
		$urlName = ereg_replace("_+",'_', $urlName);
		$urlName .= '.html';
		$this->urlName = $urlName;
		return $urlName;
	}
	private function saveUrlname() {
		global $mydb;
		$data['itemId'] = $this->itemId;
		$data['category_id'] = $this->categoryId;
		if(trim($this->contentConf['listtitle'] != "")){
			$field = $this->fields[$this->contentConf['listtitle']];
			if(!is_null($field)){
				if($field->isLanguageDependent()){
					foreach($field->getValues() as $language => $value) {
						$data['language'] = $language;
						$data['urlname'] = $this->generateUrlName($value);
						$mydb->replaceRecord($data, 'item_urls');
					}
				} else {
					$data['language'] = $this->language;
					$data['urlname'] = $this->generateUrlName($field->getValue());
					$mydb->replaceRecord($data, 'item_urls');
				}
			}
		}
	}

	public function getValue($field){
		$value = "";
		if(isset($this->fields[$field])){
			return $this->fields[$field]->getValue();
		} else {
			return "ERR " . $field . " NOT EXIST";
		}
	}

	public function getTextsDataArray($language=False){
		global $available_languages;
		if(!$language) {
			$language = $this->language;
		}
		$data = array();
		foreach($this->fields as $field) {
			if($field->isLanguageDependent()){
				$data[$field->getFieldName()] = $field->getValueByLanguage($language);
			} else {
				$data[$field->getFieldName()] = $field->getValue($language);
			}
		}
		$data[$this->table_primairykey] = $this->itemId;
		$data['language'] = $language;
		return $data;
	}

	public function toString(){
		$string = "";	
		foreach($this->fields as $field) {
			$string .= $field->toString() . "; ";
		}
		return $string;
	}

	public function delete(){
		global $mydb;
		if($this->itemId > 0) {
			foreach($this->getFilesFromDatabase() as $file) {
				$this->deleteFile($file['num']);
			}
			$query = "delete from ".$this->content_table." where ".$this->table_primairykey." = '".$this->itemId."' limit 1";
			$mydb->executeQuery($query);
			# FIXME niet alleen deleten op itemId
			$query = "delete from item_urls where itemId = '".$this->itemId."' ";
			$mydb->executeQuery($query);
			if($this->content_texts_table) {
				$query = "delete from ".$this->content_texts_table." where ".$this->table_primairykey." = '".$this->itemId."' ";
				$mydb->executeQuery($query);
			}
		}	
	}

	private function add(){
		global $mydb, $available_languages;
		$data = $this->getDataArray();
		$data['changeTime'] = $this->getChangeTime();

		$id = $mydb->insertRecord($data, $this->content_table);
		$this->itemId = $id;
		$this->isNew = false;
		if($this->content_texts_table != '') {
			# geef geen tabel naam op wanneer er geen taal afhankelijke
			# extra velden zijn. 
			foreach($available_languages as $lang => $langName){
				$textData = $this->getTextsDataArray($lang);
				$mydb->insertRecord($textData, $this->content_texts_table);
			}
		}
		$error = $this->saveFiles();
		$this->getFilesFromDatabase();
		return !$error;
	}

	private function update(){
		global $mydb, $available_languages;
		$data = $this->getDataArray();
	
		$data['changeTime'] = $this->getChangeTime();
		$mydb->updateRecord($data, $this->content_table, $this->table_primairykey, $this->itemId);
		if($this->content_texts_table) {
			foreach($available_languages as $lang => $langName){
				$textData = $this->getTextsDataArray($lang);
#				$mydb->updateRecord($textData, $this->content_texts_table, $this->table_primairykey, $this->itemId);
				$mydb->replaceRecord($textData, $this->content_texts_table);
			}
		}
		$error = $this->saveFiles();
		$this->getFilesFromDatabase();
		return !$error;
	}
	private function saveFiles() {
		$error = false;	
		foreach($this->files as $file){
			$file['item_id'] = $this->itemId;
			if(isset($this->contentConf['allowed_file_extentions'])) {
				if(!(savefile($file, $this->contentConf['table_files'], $this->contentConf['allowed_file_extentions']))){
					$error = true;
				}
			} else {
				$_SESSION['messages'][] = 'config value not set: allowed_file_extentions ('.print_r($this->contentConf, true).')';
				$_SESSION['messages'][] = 'config value not set: allowed_file_extentions';
			}
		}
		return $error;
	}
	public function getChangeTime(){
		return time();
	}

	public function getPrio(){
		return $this->prio;
	}

	public function setPrio($prio){
		$this->prio = $prio;
	}

	public function setHide($hide){
		$this->hide = $hide;
	}

	public function toggleHide(){
		$this->hide = !$this->hide;
	}

	public function setId($id){
		$this->isNew = true;
		$this->itemId = $id;
	}

	public function setAllowDuplicate() {
		$this->allowDuplicate = true;
	}

	public function setAddTime(){
		$this->addTime = time();
	}

	public function getAddTime(){
		return $this->addTime;
	}

	public function existsInDatabase(){
		global $mydb;
		$r = $mydb->getRecords($this->content_table, $this->table_primairykey, $this->itemId);
		return mysql_num_rows($r) > 0;
	}

	public function setContentWithRecord($record) {
		$this->itemId = $record['itemId'];
		$this->categoryId = $record['categoryId'];
		$this->addTime = $record['addTime'];
		$this->changeTime = $record['changeTime'];
		$this->prio = $record['prio'];
		$this->hide = $record['hide'];
		if(isset($record['dataFields'])) {
			$keyValuePairs = unserialize($record['dataFields']);
		}
		$languageFields = array();
		if($this->content_texts_table) {
			$query = "select * from ".$this->content_texts_table." where ".$this->table_primairykey." = '".$this->itemId."' and language = '".$this->language."' ";
			$result = $mydb->executeQuery($query);
			$languageFields = mysql_fetch_array($result);
		}
		foreach ($this->fields as $field){
			$thisField = $field->getFieldName();
			if(isset($keyValuePairs[$thisField])){
				$field->setValue($keyValuePairs[$thisField]);
			}
			if($field->isLanguageDependent()){
				//FIXED with isset, can cause error
				if(isset($languageFields[$thisField])){
					$v[$this->language] = $languageFields[$thisField];
					$field->setValue($v);
				}
			} else {
				//COMMAND DIT WEG ALS JE ALLES WILT UPDATEN IN DE DB...
				if(isset($record[$thisField])) {
					$field->setValue($record[$thisField]);
				}
			}
		}
	
		$this->getFilesFromDatabase();
	}

	public function getSelectTypeFields(){
		$selects = array();
		foreach ($this->fields as $field){
			if($field->getType() == 'select') {
				$selects[] = $field;
			}
		}
		return $selects;
	}
	private function getContentFromDatabase(){
		global $mydb;
		$records = $mydb->getRecords($this->content_table, $this->table_primairykey, $this->itemId);
		if(mysql_num_rows($records)) {
			$record = mysql_fetch_array($records);
		} else {
			return False;
		}
		$this->categoryId = $record['categoryId'];
		$this->addTime = $record['addTime'];
		$this->changeTime = $record['changeTime'];
		$this->prio = $record['prio'];
		$this->hide = $record['hide'];
		if(isset($record['dataFields'])) {
			$keyValuePairs = unserialize($record['dataFields']);
		}
		$languageFields = array();
		if($this->content_texts_table) {
			$query = "select * from ".$this->content_texts_table." where ".$this->table_primairykey." = '".$this->itemId."' and language = '".$this->language."' ";
			$result = $mydb->executeQuery($query);
			$languageFields = mysql_fetch_array($result);
		}
		foreach ($this->fields as $field){
			$thisField = $field->getFieldName();
			if(isset($keyValuePairs[$thisField])){
				$field->setValue($keyValuePairs[$thisField]);
			}
			if($field->isLanguageDependent()){
				//FIXED with isset, can cause error
				if(isset($languageFields[$thisField])){
					$v[$this->language] = $languageFields[$thisField];
					$field->setValue($v);
				}
			} else {
				//COMMAND DIT WEG ALS JE ALLES WILT UPDATEN IN DE DB...
				if(isset($record[$thisField])) {
					$field->setValue($record[$thisField]);
				}
			}
		}
	
		$this->getFilesFromDatabase();
	}

	private function getFilesFromDatabase(){
		global $mydb;
		$this->files=array();
		if(isset($this->contentConf['table_files']) && $this->contentConf['table_files'] != '' && isset($this->contentConf['number_of_files']) && $this->contentConf['number_of_files'] != 0){
			$records = $mydb->getRecords($this->contentConf['table_files'], "item_id", $this->itemId);
			while($record = mysql_fetch_array($records)) {
				$num = $record['num'];
				$record['mediasize'] = gethumansize($record['filesize']);
				$this->files[$num] = $record;
			}
		}
		return $this->files;
	}
	public function getFieldByName($name) {
		return $this->fields[$name];
	}

	public function getTemplateData($language=False) {
		if(!$language) {
			$language = $this->language;
		}
		$data = $this->getTextsDataArray($language);
		$data += $this->getDataArray();
		$data['id'] = $data[$this->table_primairykey];
		$data['hide'] = $this->hide;
		$data['photo'] = $this->files;
		# timezone test staat ook in standard config maar blijft klagen
		date_default_timezone_set('Europe/Amsterdam');
		if($this->changeTime != 0){
			$data['changeTime'] = date(DATEFORMAT, $this->changeTime);
		} else {
			$data['changeTime'] = date(DATEFORMAT, $this->addTime);
		}
		$data['addTime'] = date(DATEFORMAT, $this->addTime);
		if($this->listTitleField == 'itemId') {
			$data['listtitle'] = "Item ( ".$data[$this->listTitleField]." )";
		} else {
			$data['listtitle'] = $data[$this->listTitleField];
		}

		foreach ($data as $key =>$field) {
			if(is_string($field)) {
				$data[$key]= stripslashes($field);
			} else {
				$data[$key]= $field;
			}
		}
		return $data;
	}

	public function assign ($repKey, $repValue){
		foreach($this->fields as $field) {
			$field->assign($repKey, $repValue);
		}
	}
}
?>
