<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 11-06-08
 * date modified		: $Id$
 */

class Action {
	private $name;
	private $neededPermission;
	private $method;
	private $arguments;
	private $executed = false;
	private $defaultActionAllowed;
	private $log;
	private $logLevel = 1;
	
	public $NORMAL = 0;
	public $VERBOSE = 1;
	

	public function __construct($name, $neededPermission = false, $method = false, $arguments = array(), $defaultActionAllowed = false, $log = false) {
		$this->log = $log;
		$this->name = $name;
		$this->neededPermission = $neededPermission;
		$this->defaultActionAllowed = $defaultActionAllowed;
		if($method){
			$this->method = $method;
		} else {
			$this->method = $name;
		}
		$this->arguments = $arguments;
	}
	
	public function validate(){
	    $v = new Validator($this->arguments);
		return $v->isValid();
	}

	public function setLogging($logging, $level = 1) {
		$this->logLevel = $level;
		$this->log = $logging;
	}
	public function addArgument($name, $condition) {
		$this->arguments[$name] = $condition;
	}

	public function getArgumentValue($name) {
		return (isset($_REQUEST[$name]) ? $_REQUEST[$name] : False);
	}

	public function hasNeededPermission() {
		if($this->neededPermission === false){
			return true;
		}
		$userManager = new UserManager();
		$user =	$userManager->getLoggedInUser();
		return $user->hasPermission(getSelectedCat(), $this->neededPermission);
	}

	public function hasNeededAction(){
		return (isset($_REQUEST['action'])) && ($_REQUEST['action'] == $this->getName());
	}

	public function getArgument($argumentName){
		return $this->name;
	}

	public function getName(){
		return $this->name;
	}

	public function start($controller, $isDefault = false){
		if(!$isDefault && !$this->hasNeededAction()) {
#			 $_SESSION['messages'][] = "Action (".$this->getName().") is not targetted ($isDefault).";
			return false;
		}
#echo "method: ".$this->method." name: ".$this->getName().$this->hasNeededAction()."<br>\n";

		if(!$this->hasNeededPermission()){
			$_SESSION['messages'][] = "You are not authenticated to execute this action(".$this->getName().").";
			return false;
		}

		if(!$this->validate()){
			$_SESSION['messages'][] = "Arguments for this action (".$this->getName().") are not valid.";
			return false;
		}
		//$_SESSION['messages'][] = "Starting " . $this->getName() . ".". $this->method;
		$this->executed = true;
		$func = $this->method;
		$this->log();
		$controller->$func();
	}

	public function isExecuted() {
		return $this->executed;
	}

	public function isDefaultActionAllowed() {
		return $this->defaultActionAllowed;
	}

	public function setDefaultActionAllowed($val) {
		$this->defaultActionAllowed = $val;
	}

	public function log() {
		if($this->log){
			$userManager = new UserManager();
			$user = $userManager->getLoggedInUser();
			$data['name'] = $this->getName();
			$data['neededPermission'] = $this->neededPermission;
			$data['categoryId'] = getSelectedCat();
			$data['method'] = $this->method;
			if(is_object($user)) {
				$data['user'] = $user->getName();
			}
			$data['ip'] = $_SERVER['REMOTE_ADDR'];
			$data['requestUri'] = $_SERVER['REQUEST_URI'];
			$data['sessionId'] = session_id();
			$data['requestTime'] = time();
			$data['args'] = '';
			$data['request'] = "";
			foreach($this->arguments as $name => $con){
				$data['args'] .= "(" . $name . ":" . $_REQUEST[$name] . ") ";
			}
			if($this->logLevel >= $this->VERBOSE){
				foreach($_POST as $request => $value){
					$data['request'] .= "(" . $request . ":" . $value . ") ";
				}
				foreach($_GET as $request => $value){
					$data['request'] .= "(" . $request . ":" . $value . ") ";
				}
			}

			global $mydb;
			$id = $mydb->insertRecord($data, UserManager::$prefix . "actionLog");
		}
	}
}
?>
