<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 11-06-08
 * date modified		: $Id$
 */

abstract class AbstractController {
	protected	$actions = array();
	private		$defaultAction;
	protected	$currentAction;
	private		$output;
	protected	$text;
	protected	$mod;
	protected	$saveError = False;
	protected	$loggedInUser;

	public function __construct($mod, $text=array()) { 
		$this->mod = $mod;
		$this->text = $text;
		$this->output = "";
		$userManager = new UserManager();
		$this->loggedInUser = $userManager->getLoggedInUser();
	}
	
	public function getMod(){ 
		return $this->mod;
	}

	protected function message($textField, $texts=False, $clearPrevious=False, $dontTrans=False){
		if($clearPrevious) {
			$_SESSION['messages'] = array();
		}
		if($dontTrans) {
			$_SESSION['messages'][] = $textField;
		} else {
			$_SESSION['messages'][] = $this->text($textField);
		}
		if(is_array($texts)) {
			$tt = array();
			foreach($texts as $t) {
				if($dontTrans) {
					$tt[] = $t;
				} else {
					$tt[] = $this->text($t);
				}
			}
			$_SESSION['messages'][] = join(', ', $tt);
		}
	}
	protected function text($textField){
		if(isset($this->text[$textField])) {
			$t = $this->text[$textField];
		} else {
			$t = $textField;
			# put in db
			global $mydb;
			$d = array();
			$d['language'] = getSelectedLanguage();
			$d['transstring'] = $textField;
			$mydb->replaceRecord($d, 'untranslated');
		}
		return $t;
	}
	protected function getActions(){
		return array_keys($this->actions);
	}
	protected function addActions ($actions, $destinationAction) {
		foreach($actions as $action) {
			$a = new Action($action, False, $destinationAction);
			$this->addAction($a);
		}
	}
	protected function addAction ($action){
		$this->actions[$action->getName()] = $action;
	}

	protected function setDefaultAction($action){
		$this->defaultAction = $action;
	}

	public function start () {
		foreach ($this->actions as $actionName => $action) {
			$this->currentAction = $action;
			$action->start($this);
		}
		if(!$this->hadExecution() and is_object($this->defaultAction)) {
			$actionName = $this->defaultAction->getName();

#			$_SESSION['messages'][] = "Starting default action (".$this->defaultAction->getName().")";
			$this->currentAction = $this->defaultAction;
			$this->defaultAction->start($this, true);
		}
	}

	protected function hadExecution() {
		foreach ($this->actions as $actionName => $action) {
	#		$m = "Action (".$actionName.") ";
			if($action->isExecuted() && !$action->isDefaultActionAllowed()) {
	#			$_SESSION['messages'][] = $m." is executed.";
				return True;
	#		} else {
	#			$_SESSION['messages'][] = $m;
			}
		}
		return False;
	}

	protected function addOutput($output) {
		$this->output .= $output;
	}
	public function getOutput() {
		return $this->output;
	}
	public function deleteContent($itemId, $configPath) {
		$ContentItem = new content($itemId, $configPath);
# TODO getSelectedParentCat()
#		if($ContentItem->getCategoryId() == getSelectedCat()) {
			$ContentItem->delete();
			$this->message('deleted');	
#		}
	}
	public function saveContent($itemId, $configPath, $categoryId=False) {
		$this->saveError = False;
		if($categoryId === False) {
			$categoryId = getSelectedCat();
		}
		$saveContentItem = new content($itemId, $configPath);
		$saveContentItem->setCategoryId($categoryId);
        if(!$saveContentItem->parseAndSave()) {
			$this->message('errorfield', $saveContentItem->getErrorFields());
            $this->saveError = true;
        } else {
			$this->message('saved');
        }
		return $saveContentItem->getItemId();
	}
	public function showContent($itemId, $configPath, $parseField='ITEM') {
		$ContentItem = new content($itemId, $configPath);
#		$selectedCat = getSelectedCat();
#		if($ContentItem->getConfigValue('useParentCatIdForSelectedCat')) {
#	        $catManager = new CategoryManager();
#	        $selectedCat = $catManager->getParentIdFromId(getSelectedCat());
#		}
#		if(($ContentItem->getCategoryId() == $selectedCat) or ($selectedCat == 0)) {
			$this->mod->assign($parseField, $ContentItem->getTemplateData());
			return True;
#		}
#		return False;
	}
}	
?>
